/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.treelikelihood;

import dr.evolution.alignment.PatternList;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.tipstatesmodel.TipStatesModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Likelihood;
import dr.oldevomodel.sitemodel.SiteModel;
import dr.oldevomodel.substmodel.SubstitutionEpochModel;
import dr.oldevomodel.treelikelihood.TreeLikelihood;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.logging.Logger;

@Deprecated
public class EpochTreeLikelihood
extends TreeLikelihood {
    public static final String LIKE_NAME = "epochTreeLikelihood";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newBooleanRule("useAmbiguities", true), AttributeRule.newBooleanRule("allowMissingTaxa", true), AttributeRule.newBooleanRule("storePartials", true), AttributeRule.newBooleanRule("forceJavaCore", true), new ElementRule(PatternList.class), new ElementRule(TreeModel.class), new ElementRule(SiteModel.class), new ElementRule(BranchRateModel.class, true), new ElementRule(TipStatesModel.class, true)};

        @Override
        public String getParserName() {
            return EpochTreeLikelihood.LIKE_NAME;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            boolean bl = xMLObject.getAttribute("useAmbiguities", false);
            boolean bl2 = xMLObject.getAttribute("allowMissingTaxa", false);
            boolean bl3 = xMLObject.getAttribute("storePartials", true);
            boolean bl4 = xMLObject.getAttribute("forceJavaCore", false);
            PatternList patternList = (PatternList)xMLObject.getChild(PatternList.class);
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            SiteModel siteModel = (SiteModel)xMLObject.getChild(SiteModel.class);
            if (!(siteModel.getSubstitutionModel() instanceof SubstitutionEpochModel)) {
                throw new XMLParseException("EpochTreeLikelihood only currently works with a SubstitutionEpochModel");
            }
            BranchRateModel branchRateModel = (BranchRateModel)xMLObject.getChild(BranchRateModel.class);
            TipStatesModel tipStatesModel = (TipStatesModel)xMLObject.getChild(TipStatesModel.class);
            Logger.getLogger("dr.evolution").info("\n ---------------------------------\nCreating EpochTreeLikelihood model.");
            Logger.getLogger("dr.evolution").info("\tIf you publish results using substitution epoch likelihood, please reference Shapiro and Suchard (in preparation).\n---------------------------------\n");
            return new EpochTreeLikelihood(patternList, treeModel, siteModel, branchRateModel, tipStatesModel, bl, bl2, bl3, bl4);
        }

        @Override
        public String getParserDescription() {
            return "This element represents the likelihood of a patternlist on a tree given the site model.";
        }

        @Override
        public Class getReturnType() {
            return Likelihood.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public EpochTreeLikelihood(PatternList patternList, TreeModel treeModel, SiteModel siteModel, BranchRateModel branchRateModel, TipStatesModel tipStatesModel, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(patternList, treeModel, siteModel, branchRateModel, tipStatesModel, bl, bl2, bl3, bl4, false);
    }

    @Override
    protected boolean traverse(Tree tree, NodeRef nodeRef) {
        boolean bl = false;
        int n = nodeRef.getNumber();
        NodeRef nodeRef2 = tree.getParent(nodeRef);
        if (nodeRef2 != null && this.updateNode[n]) {
            double d;
            double d2;
            double d3 = this.branchRateModel.getBranchRate(tree, nodeRef);
            double d4 = d3 * ((d2 = tree.getNodeHeight(nodeRef2)) - (d = tree.getNodeHeight(nodeRef)));
            if (d4 < 0.0) {
                throw new RuntimeException("Negative branch length: " + d4);
            }
            this.likelihoodCore.setNodeMatrixForUpdate(n);
            for (int i = 0; i < this.categoryCount; ++i) {
                double d5 = this.siteModel.getRateForCategory(i) * d4;
                ((SubstitutionEpochModel)this.siteModel.getSubstitutionModel()).getTransitionProbabilities(d, d2, d5, this.probabilities);
                this.likelihoodCore.setNodeMatrix(n, i, this.probabilities);
            }
            bl = true;
        }
        if (!tree.isExternal(nodeRef)) {
            NodeRef nodeRef3 = tree.getChild(nodeRef, 0);
            boolean bl2 = this.traverse(tree, nodeRef3);
            NodeRef nodeRef4 = tree.getChild(nodeRef, 1);
            boolean bl3 = this.traverse(tree, nodeRef4);
            if (bl2 || bl3) {
                int n2 = nodeRef3.getNumber();
                int n3 = nodeRef4.getNumber();
                this.likelihoodCore.setNodePartialsForUpdate(n);
                if (this.integrateAcrossCategories) {
                    this.likelihoodCore.calculatePartials(n2, n3, n);
                } else {
                    this.likelihoodCore.calculatePartials(n2, n3, n, this.siteCategories);
                }
                if (nodeRef2 == null) {
                    double[] dArray = this.frequencyModel.getFrequencies();
                    double[] dArray2 = this.getRootPartials();
                    this.likelihoodCore.calculateLogLikelihoods(dArray2, dArray, this.patternLogLikelihoods);
                }
                bl = true;
            }
        }
        return bl;
    }
}

