/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math;

import jdplus.toolkit.base.api.math.MathException;
import lombok.Generated;

public final class Arithmetics {
    public static int[] divisors(int n) {
        int[] tmp = new int[1 + n / 2];
        int nd = Arithmetics.divisors(n, tmp);
        int[] rslt = new int[nd];
        for (int i = 0; i < nd; ++i) {
            rslt[i] = tmp[i];
        }
        return rslt;
    }

    public static int divisors(int n, int[] buffer) {
        if (n == 1) {
            return 0;
        }
        int d = 1;
        int idx = 0;
        while (d * 2 <= n) {
            if (n % d == 0) {
                buffer[idx++] = d;
            }
            ++d;
        }
        return idx;
    }

    public static int gcd(int a, int b) {
        if (a == 0) {
            return b;
        }
        if (b == 0) {
            return a;
        }
        int u = a < 0 ? -a : a;
        int v = b < 0 ? -b : b;
        int aTwos = Integer.numberOfTrailingZeros(u);
        u >>= aTwos;
        int bTwos = Integer.numberOfTrailingZeros(v);
        v >>= bTwos;
        int shift = Math.min(aTwos, bTwos);
        while (u != v) {
            int delta = u - v;
            v = Math.min(u, v);
            u = Math.abs(delta);
            u >>= Integer.numberOfTrailingZeros(u);
        }
        return u << shift;
    }

    public static long gcd(long a, long b) {
        long t;
        int k;
        long p = a;
        long q = b;
        if (p == 0L || q == 0L) {
            if (p == Long.MIN_VALUE || q == Long.MIN_VALUE) {
                throw new MathException("overflow");
            }
            return Math.abs(p) + Math.abs(q);
        }
        if (p > 0L) {
            p = -p;
        }
        if (q > 0L) {
            q = -q;
        }
        for (k = 0; (p & 1L) == 0L && (q & 1L) == 0L && k < 63; ++k) {
            p >>= 1;
            q >>= 1;
        }
        if (k == 63) {
            throw new MathException("overflow");
        }
        long l = t = (p & 1L) == 1L ? q : -(p >> 1);
        while (true) {
            if ((t & 1L) == 0L) {
                t >>= 1;
                continue;
            }
            if (t > 0L) {
                p = -t;
            } else {
                q = t;
            }
            if ((t = q - p >> 1) == 0L) break;
        }
        return -p * (1L << k);
    }

    public static int lcm(int a, int b) {
        return a * (b / Arithmetics.gcd(a, b));
    }

    public static double sumOfPowers(int k, long n) {
        double dn = n;
        switch (k) {
            case 1: {
                return dn * (dn + 1.0) / 2.0;
            }
            case 2: {
                return dn * (dn + 1.0) * (2.0 * dn + 1.0) / 6.0;
            }
            case 3: {
                return dn * dn * (dn + 1.0) * (dn + 1.0) / 4.0;
            }
            case 4: {
                return dn * (dn + 1.0) * (2.0 * dn + 1.0) * (3.0 * dn * dn + 3.0 * dn - 1.0) / 30.0;
            }
            case 5: {
                return dn * dn * (dn + 1.0) * (dn + 1.0) * (2.0 * dn * dn + 2.0 * dn - 1.0) / 12.0;
            }
            case 6: {
                double n2 = dn * dn;
                double n3 = n2 * dn;
                double n4 = n3 * dn;
                return dn * (dn + 1.0) * (2.0 * dn + 1.0) * (3.0 * n4 + 6.0 * n3 - 3.0 * dn + 1.0) / 42.0;
            }
            case 7: {
                double n2 = dn * dn;
                double n3 = n2 * dn;
                double n4 = n3 * dn;
                return dn * dn * (dn + 1.0) * (dn + 1.0) * (3.0 * n4 + 6.0 * n3 - n2 - 4.0 * dn + 2.0) / 24.0;
            }
            case 8: {
                double n2 = dn * dn;
                double n3 = n2 * dn;
                double n4 = n3 * dn;
                double n5 = n4 * dn;
                double n6 = n5 * dn;
                return dn * (dn + 1.0) * (2.0 * dn + 1.0) * (5.0 * n6 + 15.0 * n5 + 5.0 * n4 - 15.0 * n3 - n2 + 9.0 * dn - 3.0) / 90.0;
            }
            case 9: {
                double n2 = dn * dn;
                double n3 = n2 * dn;
                double n4 = n3 * dn;
                return n2 * (dn + 1.0) * (dn + 1.0) * (n2 + dn - 1.0) * (2.0 * n4 + 4.0 * n3 - n2 - 3.0 * dn + 3.0) / 20.0;
            }
            case 10: {
                double n2 = dn * dn;
                double n3 = n2 * dn;
                double n4 = n3 * dn;
                double n5 = n4 * dn;
                double n6 = n5 * dn;
                return dn * (dn + 1.0) * (2.0 * dn + 1.0) * (n2 + dn - 1.0) * (3.0 * n6 + 9.0 * n5 + 2.0 * n4 - 11.0 * n3 + 3.0 * n2 + 10.0 * dn - 5.0) / 66.0;
            }
        }
        long s = 1L;
        int i = 2;
        while ((double)i <= dn) {
            long c = i;
            for (int j = 2; j <= k; ++j) {
                c *= (long)i;
            }
            s += c;
            ++i;
        }
        return s;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long mulAndCheck(long a, long b) throws MathException {
        if (a > b) {
            return Arithmetics.mulAndCheck(b, a);
        }
        if (a < 0L) {
            if (b < 0L) {
                if (a < Long.MAX_VALUE / b) throw new MathException();
                return a * b;
            }
            if (b <= 0L) return 0L;
            if (Long.MIN_VALUE / b > a) throw new MathException();
            return a * b;
        }
        if (a <= 0L) return 0L;
        if (a > Long.MAX_VALUE / b) throw new MathException();
        return a * b;
    }

    public static int mulAndCheck(int x, int y) throws MathException {
        long m = (long)x * (long)y;
        if (m < Integer.MIN_VALUE || m > Integer.MAX_VALUE) {
            throw new MathException();
        }
        return (int)m;
    }

    @Generated
    private Arithmetics() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

