/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evolution.coalescent.TreeIntervals;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Likelihood;
import jebl.math.Binomial;

public class CoalescentConstantLikelihood
extends Likelihood.Abstract {
    public static final boolean COALESCENT_EVENTS_ONLY = false;
    private TreeModel treeModel;
    private TreeIntervals intervals;

    public CoalescentConstantLikelihood(TreeModel treeModel) {
        super(treeModel);
        this.treeModel = treeModel;
        this.intervals = new TreeIntervals(treeModel);
    }

    @Override
    public double calculateLogLikelihood() {
        this.intervals.setIntervalsUnknown();
        int n = this.intervals.getIntervalCount();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            if (this.intervals.getLineageCount(i) <= 2) continue;
            d += Math.log(Binomial.choose2(this.intervals.getLineageCount(i)));
        }
        return -d;
    }
}

