/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.polynomials;

import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.decomposition.EigenSystem;
import jdplus.toolkit.base.core.math.matrices.decomposition.IEigenSystem;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.math.polynomials.RootsSolver;

public class EigenValuesSolver
implements RootsSolver {
    private Complex[] roots;

    @Override
    public boolean factorize(Polynomial p) {
        int n = p.degree();
        this.roots = new Complex[n];
        switch (n) {
            case 0: {
                return true;
            }
            case 1: {
                this.monic(p);
                return true;
            }
            case 2: {
                this.quadratic(p);
                return true;
            }
        }
        double pn = p.get(n);
        FastMatrix M = FastMatrix.square(n + 1);
        M.subDiagonal(-1).drop(0, 1).set(1.0);
        DataBlock col = M.column(n - 1).drop(0, 1);
        col.setAY(-1.0 / pn, p.coefficients().drop(0, 1));
        M.set(0, n, 1.0);
        IEigenSystem es = EigenSystem.create(M, false);
        Complex[] ev = es.getEigenValues();
        System.arraycopy(ev, 0, this.roots, 0, n);
        return true;
    }

    @Override
    public Polynomial remainder() {
        return Polynomial.ZERO;
    }

    @Override
    public Complex[] roots() {
        return this.roots;
    }

    private void monic(Polynomial p) {
        double a = p.get(1);
        double b = p.get(0);
        this.roots[0] = Complex.cart((double)(-b / a));
    }

    private void quadratic(Polynomial p) {
        double a = p.get(2);
        double b = p.get(1);
        double c = p.get(0);
        double aa = 2.0 * a;
        double rdiscr = b * b - 4.0 * a * c;
        if (rdiscr < 0.0) {
            Complex r;
            double z = Math.sqrt(-rdiscr);
            this.roots[0] = r = Complex.cart((double)(-b / aa), (double)(z / aa));
            this.roots[1] = r.conj();
        } else {
            double z = Math.sqrt(rdiscr);
            this.roots[0] = Complex.cart((double)((-b + z) / aa));
            this.roots[1] = Complex.cart((double)((-b - z) / aa));
        }
    }
}

