/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.oneclass;

import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Instance;
import java.util.Collection;
import java.util.Iterator;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.Classifier;
import moa.classifiers.OneClassClassifier;
import moa.core.Measurement;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;

public class Autoencoder
extends AbstractClassifier
implements Classifier,
OneClassClassifier {
    private static final long serialVersionUID = 1L;
    public IntOption hiddenLayerOption = new IntOption("hiddenLayer", 'h', "The number of neurons in the hidden layer. Should be less than the dimensionality of the data stream to ensure that the identity function is not learned.", 2, 1, 100);
    public FloatOption learningRateOption = new FloatOption("learningRate", 'l', "The rate to adapt the autoencoder's weights after each instance.", 0.5);
    public FloatOption thresholdOption = new FloatOption("threshold", 't', "Determines the threshold for recognizing outliers. Higher values means fewer outliers.", 0.6, 0.001, 0.999);
    private boolean reset;
    private int numAttributes;
    private int hiddenLayerSize;
    private RealMatrix weightsOne;
    private RealMatrix weightsTwo;
    private double biasOne;
    private double biasTwo;
    private double learningRate;
    private double threshold;

    @Override
    public String getPurposeString() {
        return "An autoencoder is a neural network that attempts to reconstruct the input vector.";
    }

    @Override
    public void resetLearningImpl() {
        this.reset = true;
    }

    private void initializeNetwork() {
        this.hiddenLayerSize = this.hiddenLayerOption.getValue();
        this.learningRate = this.learningRateOption.getValue();
        this.threshold = this.thresholdOption.getValue();
        double[][] randomWeightsOne = new double[this.hiddenLayerSize][this.numAttributes];
        double[][] randomWeightsTwo = new double[this.numAttributes][this.hiddenLayerSize];
        for (int i = 0; i < this.numAttributes; ++i) {
            for (int j = 0; j < this.hiddenLayerSize; ++j) {
                randomWeightsOne[j][i] = this.classifierRandom.nextDouble();
                randomWeightsTwo[i][j] = this.classifierRandom.nextDouble();
            }
        }
        this.weightsOne = new Array2DRowRealMatrix(randomWeightsOne);
        this.weightsTwo = new Array2DRowRealMatrix(randomWeightsTwo);
        this.biasOne = this.classifierRandom.nextDouble();
        this.biasTwo = this.classifierRandom.nextDouble();
        this.reset = false;
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        if (this.reset) {
            this.numAttributes = inst.numAttributes() - 1;
            this.initializeNetwork();
        }
        this.backpropagation(inst);
    }

    private RealMatrix firstLayer(RealMatrix input) {
        RealMatrix hidden = this.weightsOne.multiply(input).scalarAdd(this.biasOne);
        double[] tempValues = new double[this.hiddenLayerSize];
        for (int i = 0; i < this.hiddenLayerSize; ++i) {
            tempValues[i] = 1.0 / (1.0 + Math.pow(Math.E, -1.0 * hidden.getEntry(i, 0)));
        }
        return new Array2DRowRealMatrix(tempValues);
    }

    private RealMatrix secondLayer(RealMatrix hidden) {
        RealMatrix output = this.weightsTwo.multiply(hidden).scalarAdd(this.biasTwo);
        double[] tempValues = new double[this.numAttributes];
        for (int i = 0; i < this.numAttributes; ++i) {
            tempValues[i] = 1.0 / (1.0 + Math.pow(Math.E, -1.0 * output.getEntry(i, 0)));
        }
        return new Array2DRowRealMatrix(tempValues);
    }

    private void backpropagation(Instance inst) {
        double[] attributeValues = new double[this.numAttributes];
        for (int i = 0; i < this.numAttributes; ++i) {
            attributeValues[i] = inst.value(i);
        }
        Array2DRowRealMatrix input = new Array2DRowRealMatrix(attributeValues);
        RealMatrix hidden = this.firstLayer((RealMatrix)input);
        RealMatrix output = this.secondLayer(hidden);
        Array2DRowRealMatrix delta = new Array2DRowRealMatrix(this.numAttributes, 1);
        double adjustBiasTwo = 0.0;
        for (int i = 0; i < this.numAttributes; ++i) {
            double inputVal = input.getEntry(i, 0);
            double outputVal = output.getEntry(i, 0);
            delta.setEntry(i, 0, (outputVal - inputVal) * outputVal * (1.0 - outputVal));
            adjustBiasTwo -= this.learningRate * delta.getEntry(i, 0) * this.biasTwo;
        }
        RealMatrix adjustmentTwo = delta.multiply(hidden.transpose()).scalarMultiply(-1.0 * this.learningRate);
        RealMatrix hidden2 = hidden.scalarMultiply(-1.0).scalarAdd(1.0);
        RealMatrix delta2 = delta.transpose().multiply(this.weightsTwo);
        double adjustBiasOne = 0.0;
        for (int i = 0; i < this.hiddenLayerSize; ++i) {
            delta2.setEntry(0, i, delta2.getEntry(0, i) * hidden2.getEntry(i, 0) * hidden.getEntry(i, 0));
            adjustBiasOne -= this.learningRate * delta2.getEntry(0, i) * this.biasOne;
        }
        RealMatrix adjustmentOne = delta2.transpose().multiply(input.transpose()).scalarMultiply(-1.0 * this.learningRate);
        this.weightsOne = this.weightsOne.add(adjustmentOne);
        this.biasOne += adjustBiasOne;
        this.weightsTwo = this.weightsTwo.add(adjustmentTwo);
        this.biasTwo += adjustBiasTwo;
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        double[] votes = new double[2];
        if (!this.reset) {
            double error = this.getAnomalyScore(inst);
            votes[0] = Math.pow(2.0, -1.0 * (error / this.threshold));
            votes[1] = 1.0 - votes[0];
        }
        return votes;
    }

    @Override
    public double getAnomalyScore(Instance inst) {
        double error = 0.0;
        if (!this.reset) {
            double[] attributeValues = new double[inst.numAttributes() - 1];
            for (int i = 0; i < attributeValues.length; ++i) {
                attributeValues[i] = inst.value(i);
            }
            Array2DRowRealMatrix input = new Array2DRowRealMatrix(attributeValues);
            RealMatrix output = this.secondLayer(this.firstLayer((RealMatrix)input));
            for (int i = 0; i < this.numAttributes; ++i) {
                error += 0.5 * Math.pow(output.getEntry(i, 0) - input.getEntry(i, 0), 2.0);
            }
        }
        return error;
    }

    @Override
    public boolean isRandomizable() {
        return true;
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return null;
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
    }

    @Override
    public void initialize(Collection<Instance> trainingPoints) {
        Iterator<Instance> trgPtsIterator = trainingPoints.iterator();
        if (trgPtsIterator.hasNext() && this.reset) {
            Instance inst = trgPtsIterator.next();
            this.numAttributes = inst.numAttributes() - 1;
            this.initializeNetwork();
        }
        while (trgPtsIterator.hasNext()) {
            this.trainOnInstance(trgPtsIterator.next());
        }
    }
}

