/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.bigfasttree.thorney;

import java.util.ArrayList;

public interface MutationList {
    public double getMutationCount();

    public static class SimpleMutationList
    implements MutationList {
        private double mutations;

        public SimpleMutationList(double d) {
            this.mutations = d;
        }

        @Override
        public double getMutationCount() {
            return this.mutations;
        }

        public void setMutationCount(double d) {
            this.mutations = d;
        }
    }

    public static class DetailedMutationList
    implements MutationList {
        private ArrayList<Mutation> mutations = new ArrayList();

        @Override
        public double getMutationCount() {
            return this.mutations.size();
        }

        public int getSite(int n) {
            return this.mutations.get(n).site;
        }

        public int getRef(int n) {
            return this.mutations.get(n).ref;
        }

        public int getAlt(int n) {
            return this.mutations.get(n).alt;
        }

        public void addMutation(Mutation mutation) {
            this.mutations.add(mutation);
        }

        public Mutation removeMutation(int n) {
            return this.mutations.remove(n);
        }

        protected class Mutation {
            private final int alt;
            private final int ref;
            private final int site;

            protected Mutation(int n, int n2, int n3) {
                this.alt = n3;
                this.ref = n2;
                this.site = n;
            }
        }
    }
}

