/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Bounds;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;
import java.util.ArrayList;

public class JointParameter
extends Parameter.Abstract
implements VariableListener {
    private final ArrayList<Parameter> parameters = new ArrayList();
    private int dimension;
    private String name;

    public JointParameter(String string, Parameter[] parameterArray) {
        this(string);
        for (Parameter parameter : parameterArray) {
            this.addParameter(parameter);
        }
    }

    public JointParameter(String string) {
        this.name = string;
        this.dimension = 0;
    }

    public void addParameter(Parameter parameter) {
        if (this.dimension == 0) {
            this.dimension = parameter.getDimension();
        } else {
            for (int i = 0; i < this.dimension; ++i) {
                parameter.setParameterValue(i, this.parameters.get(0).getParameterValue(i));
            }
            if (parameter.getDimension() != this.dimension) {
                throw new RuntimeException("subsequent parameters do not match the dimensionality of the first");
            }
        }
        this.parameters.add(parameter);
    }

    @Override
    public final String getParameterName() {
        if (this.name != null) {
            return this.name;
        }
        return this.getId();
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public void setDimension(int n) {
        throw new RuntimeException();
    }

    @Override
    public void addBounds(Bounds<Double> bounds) {
        throw new RuntimeException("Can't add bounds to a joint parameter, only its components");
    }

    @Override
    public Bounds<Double> getBounds() {
        return this.parameters.get(0).getBounds();
    }

    @Override
    public void addDimension(int n, double d) {
        throw new RuntimeException();
    }

    @Override
    public double removeDimension(int n) {
        throw new RuntimeException();
    }

    @Override
    public double getParameterValue(int n) {
        return this.parameters.get(0).getParameterValue(n);
    }

    @Override
    public void setParameterValue(int n, double d) {
        for (Parameter parameter : this.parameters) {
            parameter.setParameterValue(n, d);
        }
    }

    @Override
    public void setParameterValueQuietly(int n, double d) {
        for (Parameter parameter : this.parameters) {
            parameter.setParameterValueQuietly(n, d);
        }
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, double d) {
        for (Parameter parameter : this.parameters) {
            parameter.setParameterValueNotifyChangedAll(n, d);
        }
    }

    @Override
    protected void storeValues() {
        for (Parameter parameter : this.parameters) {
            parameter.storeParameterValues();
        }
    }

    @Override
    protected void restoreValues() {
        for (Parameter parameter : this.parameters) {
            parameter.restoreParameterValues();
        }
    }

    @Override
    protected final void acceptValues() {
        for (Parameter parameter : this.parameters) {
            parameter.acceptParameterValues();
        }
    }

    @Override
    protected final void adoptValues(Parameter parameter) {
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.getParameterValue(0)));
        Bounds<Double> bounds = this.getBounds();
        stringBuffer.append("[").append(String.valueOf(bounds.getLowerLimit(0)));
        stringBuffer.append(",").append(String.valueOf(bounds.getUpperLimit(0))).append("]");
        for (int i = 1; i < this.getDimension(); ++i) {
            stringBuffer.append(", ").append(String.valueOf(this.getParameterValue(i)));
            stringBuffer.append("[").append(String.valueOf(bounds.getLowerLimit(i)));
            stringBuffer.append(",").append(String.valueOf(bounds.getUpperLimit(i))).append("]");
        }
        return stringBuffer.toString();
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable.getSize() > 1) {
            this.fireParameterChangedEvent(n, changeType);
        } else {
            this.fireParameterChangedEvent();
        }
    }
}

