/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats;

import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoublesMath;
import jdplus.toolkit.base.api.stats.AutoCovariances;
import jdplus.toolkit.base.core.data.analysis.WindowFunction;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.GeneralMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import lombok.Generated;

public final class RobustCovarianceComputer {
    public static FastMatrix covariance(FastMatrix x, WindowFunction winFunction, int truncationLag) {
        DoubleUnaryOperator w = winFunction.window();
        int n = x.getRowsCount();
        int nx = x.getColumnsCount();
        FastMatrix s = SymmetricMatrix.XtX(x);
        double q = 1 + truncationLag;
        for (int l = 1; l <= truncationLag; ++l) {
            double wl = w.applyAsDouble((double)l / q);
            FastMatrix m = x.extract(0, n - l, 0, nx);
            FastMatrix ml = x.extract(l, n - l, 0, nx);
            FastMatrix ol = GeneralMatrix.AtB(m, ml);
            s.addAY(wl, ol);
            s.addAYt(wl, ol);
        }
        s.div(n);
        return s;
    }

    public static double covariance(DoubleSeq x, WindowFunction winFunction, int truncationLag) {
        DoubleUnaryOperator w = winFunction.window();
        DoubleSeq y = DoublesMath.removeMean((DoubleSeq)x);
        IntToDoubleFunction acf = AutoCovariances.autoCovarianceFunction((DoubleSeq)y, (double)0.0);
        double s = acf.applyAsDouble(0);
        double q = 1 + truncationLag;
        for (int l = 1; l <= truncationLag; ++l) {
            double wl = w.applyAsDouble((double)l / q);
            s += 2.0 * wl * acf.applyAsDouble(l);
        }
        return s;
    }

    @Generated
    private RobustCovarianceComputer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

