/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.alignment;

import dr.evolution.alignment.Alignment;
import dr.evolution.datatype.DataType;
import dr.evolution.sequence.Sequence;
import dr.evolution.util.Taxon;
import java.util.Iterator;
import java.util.List;

public class GapStrippedAlignment
extends Alignment.Abstract {
    Alignment alignment;
    boolean[] hasGap = null;

    public GapStrippedAlignment(Alignment alignment) {
        this.alignment = alignment;
        DataType dataType = alignment.getDataType();
        this.hasGap = new boolean[alignment.getSiteCount()];
        block0: for (int i = 0; i < this.hasGap.length; ++i) {
            for (int j = 0; j < alignment.getSequenceCount(); ++j) {
                if (!dataType.isGapState(this.alignment.getState(j, i))) continue;
                this.hasGap[i] = true;
                continue block0;
            }
        }
    }

    @Override
    public final void setDataType(DataType dataType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final String getAlignedSequenceString(int n) {
        return this.getSequence(n).getSequenceString();
    }

    @Override
    public final String getUnalignedSequenceString(int n) {
        return this.getSequence(n).getSequenceString();
    }

    @Override
    public final int getSequenceCount() {
        return this.alignment.getSequenceCount();
    }

    @Override
    public final Sequence getSequence(int n) {
        DataType dataType = this.getDataType();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.alignment.getSiteCount(); ++i) {
            if (this.hasGap[i]) continue;
            stringBuffer.append(dataType.getChar(this.alignment.getState(n, i)));
        }
        return new Sequence(stringBuffer.toString());
    }

    @Override
    public final void setSequenceAttribute(int n, String string, Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Object getSequenceAttribute(int n, String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Sequence> getSequences() {
        return this.alignment.getSequences();
    }

    @Override
    public final int getTaxonCount() {
        return this.alignment.getTaxonCount();
    }

    @Override
    public final Taxon getTaxon(int n) {
        return this.alignment.getTaxon(n);
    }

    @Override
    public final String getTaxonId(int n) {
        return this.alignment.getTaxonId(n);
    }

    @Override
    public final int getTaxonIndex(String string) {
        return this.alignment.getTaxonIndex(string);
    }

    @Override
    public final int getTaxonIndex(Taxon taxon) {
        return this.alignment.getTaxonIndex(taxon);
    }

    @Override
    public final Object getTaxonAttribute(int n, String string) {
        return this.alignment.getTaxonAttribute(n, string);
    }

    @Override
    public List<Taxon> asList() {
        return this.alignment.asList();
    }

    @Override
    public Iterator<Taxon> iterator() {
        return this.alignment.iterator();
    }

    @Override
    public final int getSiteCount() {
        int n = 0;
        for (int i = 0; i < this.hasGap.length; ++i) {
            if (this.hasGap[i]) continue;
            ++n;
        }
        return n;
    }

    @Override
    public final int[] getSitePattern(int n) {
        return this.alignment.getSitePattern(this.fullIndex(n));
    }

    @Override
    public double[][] getUncertainSitePattern(int n) {
        return this.alignment.getUncertainSitePattern(this.fullIndex(n));
    }

    @Override
    public final int getPatternIndex(int n) {
        return this.alignment.getPatternIndex(this.fullIndex(n));
    }

    @Override
    public final int getState(int n, int n2) {
        return this.alignment.getState(n, this.fullIndex(n2));
    }

    @Override
    public double[] getUncertainState(int n, int n2) {
        return this.alignment.getUncertainState(n, this.fullIndex(n2));
    }

    @Override
    public double[][] getUncertainPattern(int n) {
        return this.alignment.getUncertainPattern(this.fullIndex(n));
    }

    @Override
    public double[] getUncertainPatternState(int n, int n2) {
        return new double[0];
    }

    @Override
    public final DataType getDataType() {
        return this.alignment.getDataType();
    }

    @Override
    public boolean areUncertain() {
        return false;
    }

    private final int fullIndex(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            if (!this.hasGap[n3]) {
                ++n2;
            }
            ++n3;
        }
        return n3;
    }
}

