/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.LongMatrix3D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix1D;
import cern.colt.matrix.tlong.impl.WrapperLongMatrix2D;

class DelegateLongMatrix2D
extends LongMatrix2D {
    private static final long serialVersionUID = 1L;
    protected LongMatrix3D content;
    protected int index;
    protected int axis;

    public DelegateLongMatrix2D(LongMatrix3D longMatrix3D, int n, int n2) {
        switch (n) {
            case 0: {
                if (n2 < 0 || n2 >= longMatrix3D.slices()) {
                    throw new IllegalArgumentException();
                }
                this.setUp(longMatrix3D.rows(), longMatrix3D.columns());
                break;
            }
            case 1: {
                if (n2 < 0 || n2 >= longMatrix3D.rows()) {
                    throw new IllegalArgumentException();
                }
                this.setUp(longMatrix3D.slices(), longMatrix3D.columns());
                break;
            }
            case 2: {
                if (n2 < 0 || n2 >= longMatrix3D.columns()) {
                    throw new IllegalArgumentException();
                }
                this.setUp(longMatrix3D.slices(), longMatrix3D.rows());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.axis = n;
        this.index = n2;
        this.content = longMatrix3D;
    }

    public synchronized long getQuick(int n, int n2) {
        switch (this.axis) {
            case 0: {
                return this.content.getQuick(this.index, n, n2);
            }
            case 1: {
                return this.content.getQuick(n, this.index, n2);
            }
            case 2: {
                return this.content.getQuick(n, n2, this.index);
            }
        }
        throw new IllegalArgumentException();
    }

    public LongMatrix2D like(int n, int n2) {
        return this.content.like2D(n, n2);
    }

    public synchronized void setQuick(int n, int n2, long l) {
        switch (this.axis) {
            case 0: {
                this.content.setQuick(this.index, n, n2, l);
                break;
            }
            case 1: {
                this.content.setQuick(n, this.index, n2, l);
                break;
            }
            case 2: {
                this.content.setQuick(n, n2, this.index, l);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public LongMatrix1D viewColumn(int n) {
        this.checkColumn(n);
        return new WrapperLongMatrix2D(this).viewColumn(n);
    }

    public Object elements() {
        return this.content.elements();
    }

    protected LongMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        throw new InternalError();
    }

    public LongMatrix1D like1D(int n) {
        throw new InternalError();
    }

    protected LongMatrix1D like1D(int n, int n2, int n3) {
        throw new InternalError();
    }

    public LongMatrix1D vectorize() {
        DenseLongMatrix1D denseLongMatrix1D = new DenseLongMatrix1D(this.rows * this.columns);
        int n = 0;
        for (int i = 0; i < this.columns; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                ((LongMatrix1D)denseLongMatrix1D).setQuick(n++, this.getQuick(j, i));
            }
        }
        return denseLongMatrix1D;
    }
}

