/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima;

import ec.tstoolkit.arima.ArimaException;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.linearfilters.SymmetricFilter;
import ec.tstoolkit.maths.matrices.Householder;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixException;
import ec.tstoolkit.maths.matrices.SparseSystemSolver;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.polynomials.RationalFunction;
import ec.tstoolkit.utilities.Arrays2;

public class AutoCovarianceFunction {
    private static final int BLOCK = 36;
    private Polynomial ar_;
    private Polynomial ma_;
    private SymmetricFilter sma_;
    private double[] c_;
    private double var_;
    private Method method_ = Method.Default2;

    public AutoCovarianceFunction(Polynomial ma, Polynomial ar, double var) {
        this.ma_ = ma;
        this.ar_ = ar;
        this.var_ = var;
    }

    public AutoCovarianceFunction(SymmetricFilter sma, BackFilter ar) {
        this.sma_ = sma;
        this.ar_ = ar.getPolynomial();
        this.var_ = 1.0;
        this.method_ = Method.SymmetricFilterDecomposition;
    }

    public Method getMethod() {
        return this.method_;
    }

    public void setMethod(Method method) {
        if (this.ma_ == null && (method == Method.Default || method == Method.Default2)) {
            throw new ArimaException("Invalid acf method");
        }
        this.method_ = method;
        this.c_ = null;
    }

    public double[] values(int n) {
        this.prepare(n);
        double[] a = new double[n];
        int nmax = Math.min(n, this.c_.length);
        Arrays2.copy(this.c_, a, nmax);
        return a;
    }

    public double get(int k) {
        this.prepare(k + 1);
        if (k >= this.c_.length) {
            return 0.0;
        }
        return this.c_[k];
    }

    public int getBound() {
        if (!this.hasBound()) {
            return -1;
        }
        return this.ma_.getDegree() + 1;
    }

    public boolean hasBound() {
        return this.ar_.getDegree() + 1 == 1;
    }

    public void prepare(int rank) {
        if (rank == 0) {
            rank = 36;
        } else {
            int r = rank % 36;
            if (r != 0) {
                rank += 36 - r;
            }
        }
        if (this.c_ != null && this.c_.length > rank) {
            return;
        }
        switch (this.method_.ordinal()) {
            case 0: {
                this.computeDefault(rank);
                break;
            }
            case 1: {
                this.computeDefault2(rank);
                break;
            }
            case 2: {
                this.computeSymmetric(rank, true);
                break;
            }
            case 3: {
                this.computeSymmetric(rank, false);
            }
        }
    }

    private void computeDefault(int rank) {
        int q;
        int p = this.ar_.getDegree() + 1;
        int r0 = Math.max(p, q = this.ma_.getDegree() + 1);
        if (rank < r0) {
            rank = r0;
        }
        int k0 = r0;
        if (this.c_ == null) {
            int i;
            this.c_ = new double[rank + 1];
            RationalFunction rfe = new RationalFunction(this.ma_, this.ar_);
            double[] cr = rfe.coefficients(q);
            Matrix c = new Matrix(r0, r0 + 1);
            for (i = 0; i < q; ++i) {
                double s = 0.0;
                for (int j = i; j < q; ++j) {
                    s += this.ma_.get(j) * cr[j - i];
                }
                c.set(i, r0, s);
            }
            for (i = 0; i < r0; ++i) {
                for (int j = 0; j < p; ++j) {
                    double w = this.ar_.get(j);
                    if (w == 0.0) continue;
                    c.add(i, i < j ? j - i : i - j, w);
                }
            }
            if (!SparseSystemSolver.solve(c)) {
                throw new ArimaException("acgf_err_st");
            }
            for (i = 0; i < r0; ++i) {
                this.c_[i] = c.get(i, r0) * this.var_;
            }
        } else {
            double[] tmp = new double[rank + 1];
            for (double tmp[u] : this.c_) {
            }
            this.c_ = tmp;
        }
        for (int r = k0; r <= rank; ++r) {
            double s = 0.0;
            for (int x = 1; x < p; ++x) {
                s += this.ar_.get(x) * this.c_[r - x];
            }
            this.c_[r] = -s;
        }
    }

    private void computeDefault2(int rank) {
        int q;
        int p = this.ar_.getDegree() + 1;
        int r0 = Math.max(p, q = this.ma_.getDegree() + 1);
        if (rank < r0) {
            rank = r0;
        }
        int k0 = r0;
        if (this.c_ == null) {
            try {
                this.c_ = new double[rank + 1];
                RationalFunction rfe = new RationalFunction(this.ma_, this.ar_);
                double[] cr = rfe.coefficients(q);
                double[] m = new double[r0];
                for (int i = 0; i < q; ++i) {
                    double s = 0.0;
                    for (int j = i; j < q; ++j) {
                        s += this.ma_.get(j) * cr[j - i];
                    }
                    m[i] = s;
                }
                Matrix c = new Matrix(r0, r0);
                for (int i = 0; i < r0; ++i) {
                    for (int j = 0; j < p; ++j) {
                        double w = this.ar_.get(j);
                        if (w == 0.0) continue;
                        c.add(i, i < j ? j - i : i - j, w);
                    }
                }
                Householder qr = new Householder(false);
                qr.decompose(c);
                double[] tmp = qr.solve(m);
                for (int i = 0; i < r0; ++i) {
                    this.c_[i] = tmp[i] * this.var_;
                }
            }
            catch (MatrixException err) {
                throw new ArimaException("acgf_err_st");
            }
        } else {
            double[] tmp = new double[rank + 1];
            for (double tmp[u] : this.c_) {
            }
            this.c_ = tmp;
        }
        for (int r = k0; r <= rank; ++r) {
            double s = 0.0;
            for (int x = 1; x < p; ++x) {
                s += this.ar_.get(x) * this.c_[r - x];
            }
            this.c_[r] = -s;
        }
    }

    private void computeSymmetric(int rank, boolean dsym) {
        int q;
        int p = this.ar_.getDegree() + 1;
        int r0 = Math.max(p, q = this.sma_ != null ? this.sma_.getDegree() + 1 : this.ma_.getDegree() + 1);
        if (rank < r0) {
            rank = r0;
        }
        if (p == 1) {
            if (this.sma_ == null) {
                this.sma_ = SymmetricFilter.createFromFilter(new BackFilter(this.ma_));
            }
            this.c_ = this.sma_.getCoefficients();
            new DataBlock(this.c_).mul(this.var_);
        } else {
            double[] tmp;
            if (this.c_ == null) {
                this.c_ = new double[rank + 1];
                if (this.sma_ == null) {
                    this.sma_ = SymmetricFilter.createFromFilter(new BackFilter(this.ma_));
                }
                BackFilter g = dsym ? this.sma_.decompose(new BackFilter(this.ar_)) : this.sma_.decompose2(new BackFilter(this.ar_));
                tmp = new RationalFunction(g.getPolynomial(), this.ar_).coefficients(rank + 1);
                if (this.var_ != 1.0) {
                    this.c_[0] = 2.0 * tmp[0] * this.var_;
                    for (int i = 1; i < tmp.length; ++i) {
                        this.c_[i] = tmp[i] * this.var_;
                    }
                } else {
                    System.arraycopy(tmp, 0, this.c_, 0, tmp.length);
                    this.c_[0] = this.c_[0] * 2.0;
                }
            }
            if (rank < this.c_.length) {
                return;
            }
            int k0 = this.c_.length;
            tmp = new double[rank];
            for (int u = 0; u < k0; ++u) {
                tmp[u] = this.c_[u];
            }
            this.c_ = tmp;
            for (int r = k0; r < rank; ++r) {
                double s = 0.0;
                for (int x = 1; x < p; ++x) {
                    s += this.ar_.get(x) * this.c_[r - x];
                }
                this.c_[r] = -s;
            }
        }
    }

    public static enum Method {
        Default,
        Default2,
        SymmetricFilterDecomposition,
        SymmetricFilterDecomposition2;

    }
}

