/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.timeseries.regression.AbstractTsModifier;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.util.List;

public class DecoratedTsVariable
extends AbstractTsModifier {
    private final String name;

    public DecoratedTsVariable(ITsVariable var, String name) {
        super(var);
        this.name = name;
    }

    @Override
    public ITsVariable getVariable() {
        return this.var;
    }

    @Override
    @Deprecated
    public void data(TsDomain domain, List<DataBlock> data, int start) {
        this.var.data(domain, data, start);
    }

    @Override
    public void data(TsDomain domain, List<DataBlock> data) {
        this.var.data(domain, data);
    }

    @Override
    public TsDomain getDefinitionDomain() {
        return this.var.getDefinitionDomain();
    }

    @Override
    public TsFrequency getDefinitionFrequency() {
        return this.var.getDefinitionFrequency();
    }

    @Override
    public String getDescription(TsFrequency context) {
        return this.name;
    }

    @Override
    public int getDim() {
        return this.var.getDim();
    }

    @Override
    public String getItemDescription(int idx, TsFrequency context) {
        if (this.var.getDim() == 1) {
            return this.name;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.name).append('[').append(idx + 1).append(']');
        return builder.toString();
    }

    @Override
    public boolean isSignificant(TsDomain domain) {
        return this.var.isSignificant(domain);
    }

    @Override
    public String getName() {
        String cname = this.name.replace('.', '@');
        int n = this.getDim();
        if (n == 1) {
            return cname;
        }
        return cname + '#' + n;
    }
}

