/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy;

import keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy.Fuzzy;
import keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy.FuzzyInterval;

class FuzzyNumberTRRIGHT
extends Fuzzy {
    double left;
    double center;

    public FuzzyNumberTRRIGHT(double l, double c) {
        this.left = l;
        this.center = c;
    }

    public FuzzyNumberTRRIGHT(FuzzyNumberTRRIGHT b) {
        this.left = b.left;
        this.center = b.center;
    }

    public void asigna(FuzzyNumberTRRIGHT b) {
        this.left = b.left;
        this.center = b.center;
    }

    @Override
    public boolean equals(Fuzzy b) {
        if (!(b instanceof FuzzyNumberTRRIGHT)) {
            return false;
        }
        FuzzyNumberTRRIGHT bt = (FuzzyNumberTRRIGHT)b;
        if (this.left != bt.left) {
            return false;
        }
        return this.center == bt.center;
    }

    @Override
    public Fuzzy clone() {
        return new FuzzyNumberTRRIGHT(this);
    }

    @Override
    public double evaluateMembership(double x) {
        if (x < this.left) {
            return 0.0;
        }
        if (x < this.center) {
            return 1.0 - (this.center - x) / (this.center - this.left);
        }
        return 1.0;
    }

    @Override
    public double massCentre() {
        return this.center;
    }

    @Override
    public FuzzyInterval support() {
        return new FuzzyInterval(this.left, 1.0E10);
    }

    @Override
    public String aString() {
        return "TRAPRI(" + this.left + "," + this.center + ")";
    }
}

