/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.DT_GA;

import java.util.ArrayList;
import keel.Algorithms.Decision_Trees.DT_GA.Regla;
import keel.Algorithms.Decision_Trees.DT_GA.Selector;
import keel.Algorithms.Decision_Trees.DT_GA.myDataset;
import org.core.Randomize;

public class Individuo
implements Comparable {
    Selector[] antecedente;
    boolean[] seleccionado;
    String clase;
    myDataset train;
    double fitness;
    boolean n_e;
    int codigoRegla;

    public Individuo() {
        this.antecedente = new Selector[1];
        this.antecedente[0] = new Selector();
        this.seleccionado = new boolean[1];
        this.n_e = true;
    }

    public Individuo(boolean[] antecedentes, String clase, myDataset train, int codigo) {
        this.clase = clase;
        this.train = train;
        this.antecedente = new Selector[antecedentes.length];
        this.seleccionado = new boolean[antecedentes.length];
        this.seleccionado = (boolean[])antecedentes.clone();
        for (int i = 0; i < antecedentes.length; ++i) {
            if (!this.seleccionado[i]) continue;
            this.antecedente[i] = new Selector(i, train);
        }
        this.n_e = true;
        this.codigoRegla = codigo;
    }

    public Individuo(myDataset train, int pos_ejemplo) {
        int i;
        this.clase = "?";
        this.train = train;
        this.antecedente = new Selector[train.getnInputs()];
        this.seleccionado = new boolean[train.getnInputs()];
        double[] ejemplo = train.getExample(pos_ejemplo);
        for (i = 0; i < this.seleccionado.length; ++i) {
            this.seleccionado[i] = true;
        }
        for (i = 0; i < this.antecedente.length; ++i) {
            this.antecedente[i] = new Selector(i, train);
            if (this.antecedente[i].cubre(ejemplo)) continue;
            this.antecedente[i].modifica(ejemplo);
        }
        this.n_e = true;
    }

    public Individuo(Individuo padre, Individuo madre, int puntoCorte) {
        int i;
        this.antecedente = new Selector[padre.size()];
        this.seleccionado = new boolean[padre.size()];
        for (i = 0; i < puntoCorte; ++i) {
            this.seleccionado[i] = padre.seleccionado[i];
            if (!this.seleccionado[i]) continue;
            this.antecedente[i] = padre.antecedente[i].copia();
        }
        for (i = puntoCorte; i < madre.size(); ++i) {
            this.seleccionado[i] = madre.seleccionado[i];
            if (!this.seleccionado[i]) continue;
            this.antecedente[i] = madre.antecedente[i].copia();
        }
        this.clase = padre.clase;
        this.train = padre.train;
        this.fitness = 0.0;
        this.codigoRegla = padre.codigoRegla;
        this.n_e = true;
    }

    public String printString() {
        String cadena = new String("");
        cadena = cadena + "IF ";
        for (int i = 0; i < this.antecedente.length; ++i) {
            if (!this.seleccionado[i]) continue;
            cadena = cadena + this.antecedente[i].printString() + "AND ";
        }
        cadena = cadena + " THEN Class = " + this.clase + "\n";
        return cadena;
    }

    public Regla convertir() {
        Regla r = new Regla();
        r.antecedente = new ArrayList();
        for (int i = 0; i < this.antecedente.length; ++i) {
            if (!this.seleccionado[i]) continue;
            r.antecedente.add(this.antecedente[i].copia());
        }
        r.clase = this.clase;
        r.train = this.train;
        r.ejemplosCubiertos = new int[this.train.size()];
        r.nCubiertos = 0;
        r.ejemplosBienCubiertos = new int[this.train.size()];
        r.nCubiertosOK = 0;
        r.fitness = this.fitness;
        r.codigoRegla = this.codigoRegla;
        r.cubrirEjemplos();
        return r;
    }

    public Individuo clone() {
        Individuo ind = new Individuo();
        ind.seleccionado = new boolean[this.seleccionado.length];
        ind.seleccionado = (boolean[])this.seleccionado.clone();
        ind.antecedente = new Selector[this.antecedente.length];
        for (int i = 0; i < this.antecedente.length; ++i) {
            if (!this.seleccionado[i]) continue;
            ind.antecedente[i] = this.antecedente[i].copia();
        }
        ind.clase = this.clase;
        ind.fitness = this.fitness;
        ind.train = this.train;
        ind.n_e = this.n_e;
        ind.codigoRegla = this.codigoRegla;
        return ind;
    }

    public double clasifica(int[] ejemplos, int nEjemplos) {
        int fp = 0;
        int tn = 0;
        int fn = 0;
        int tp = 0;
        boolean algunoCubierto = false;
        for (int j = 0; j < nEjemplos; ++j) {
            boolean cubierto = true;
            boolean completo = false;
            double[] ejemplo = this.train.getExample(ejemplos[j]);
            for (int i = 0; i < this.antecedente.length && cubierto; ++i) {
                if (!this.seleccionado[i]) continue;
                completo = true;
                cubierto = cubierto && this.antecedente[i].cubre(ejemplo);
            }
            cubierto = cubierto && completo;
            String clase = this.train.getOutputAsString(ejemplos[j]);
            if (cubierto) {
                algunoCubierto = true;
                if (clase.equalsIgnoreCase(this.clase)) {
                    ++tp;
                    continue;
                }
                ++fp;
                continue;
            }
            if (clase.equalsIgnoreCase(this.clase)) {
                ++fn;
                continue;
            }
            ++tn;
        }
        if (!algunoCubierto) {
            fn = 0;
            fp = 0;
            tn = 0;
            tp = 0;
        }
        double sens = 1.0;
        if (tp + fn > 0) {
            sens = 1.0 * (double)tp / (double)(tp + fn);
        }
        double spec = 1.0;
        if (tn + fp > 0) {
            spec = 1.0 * (double)tn / (double)(fp + tn);
        }
        if (tp + tn == 0) {
            spec = 0.0;
            sens = 0.0;
        }
        this.n_e = false;
        this.fitness = sens * spec;
        return this.fitness;
    }

    public double clasificaLarge(int[] ejemplos, int nEjemplos) {
        int i;
        int fp = 0;
        int tn = 0;
        int fn = 0;
        int tp = 0;
        int nClases = this.train.getnClasses();
        int[] cubiertosClase = new int[nClases];
        boolean[] cubiertos = new boolean[this.train.size()];
        for (int j = 0; j < nEjemplos; ++j) {
            boolean cubierto = true;
            boolean completo = false;
            double[] ejemplo = this.train.getExample(ejemplos[j]);
            for (int i2 = 0; i2 < this.antecedente.length && cubierto; ++i2) {
                if (!this.seleccionado[i2]) continue;
                completo = true;
                cubierto = cubierto && this.antecedente[i2].cubre(ejemplo);
            }
            boolean bl = cubierto = cubierto && completo;
            if (cubierto) {
                int clase;
                int n = clase = this.train.getOutputAsInteger(ejemplos[j]);
                cubiertosClase[n] = cubiertosClase[n] + 1;
            }
            cubiertos[j] = cubierto;
        }
        int maxCubiertos = 0;
        for (i = 0; i < nClases; ++i) {
            if (cubiertosClase[i] <= maxCubiertos) continue;
            maxCubiertos = cubiertosClase[i];
            this.clase = this.train.nombreClase(i);
        }
        if (maxCubiertos > 0) {
            for (i = 0; i < this.train.size(); ++i) {
                String clase = this.train.getOutputAsString(i);
                if (cubiertos[i]) {
                    if (clase.equalsIgnoreCase(this.clase)) {
                        ++tp;
                        continue;
                    }
                    ++fp;
                    continue;
                }
                if (clase.equalsIgnoreCase(this.clase)) {
                    ++fn;
                    continue;
                }
                ++tn;
            }
        }
        double sens = 1.0;
        if (tp + fn > 0) {
            sens = 1.0 * (double)tp / (double)(tp + fn);
        }
        double spec = 1.0;
        if (tn + fp > 0) {
            spec = 1.0 * (double)tn / (double)(fp + tn);
        }
        if (tp + tn == 0) {
            spec = 0.0;
            sens = 0.0;
        }
        this.n_e = false;
        this.fitness = sens * spec;
        return this.fitness;
    }

    public int size() {
        return this.antecedente.length;
    }

    public void mutar(double mutProb) {
        for (int i = 0; i < this.antecedente.length; ++i) {
            if (!this.seleccionado[i] || !(Randomize.Rand() < mutProb)) continue;
            this.antecedente[i].mutar();
        }
    }

    private double infoGcondi(int atributo, int[] ejemplos, int T) {
        double info = 0.0;
        int noVi = 0;
        int Vi = 0;
        int[] Vij = new int[this.train.getnClasses()];
        int[] noVij = new int[this.train.getnClasses()];
        for (int i = 0; i < Vij.length; ++i) {
            noVij[i] = 0;
            Vij[i] = 0;
        }
        for (int j = 0; j < T; ++j) {
            double[] ejemplo = this.train.getExample(ejemplos[j]);
            boolean cubierto = this.antecedente[atributo].cubre(ejemplo);
            int clase = this.train.getOutputAsInteger(ejemplos[j]);
            if (cubierto) {
                ++Vi;
                int n = clase;
                Vij[n] = Vij[n] + 1;
                continue;
            }
            ++noVi;
            int n = clase;
            noVij[n] = noVij[n] + 1;
        }
        double sum2 = 0.0;
        double sum1 = 0.0;
        for (int i = 0; i < Vij.length; ++i) {
            double aux = 1.0 * (double)Vij[i] / (double)Vi;
            sum1 += aux * (Math.log(aux) / Math.log(2.0));
            aux = 1.0 * (double)noVij[i] / (double)noVi;
            sum2 += aux * (Math.log(aux) / Math.log(2.0));
        }
        info = -(sum1 *= 1.0 * (double)Vi / (double)T) - (sum2 *= 1.0 * (double)noVi / (double)T);
        return info;
    }

    public void pruning(double infoG, int nEjemplos, int[] ejemplos) {
        int i;
        double[] info_gain = new double[this.antecedente.length];
        int[] atributos = new int[this.antecedente.length];
        int n = 0;
        for (i = 0; i < this.antecedente.length; ++i) {
            atributos[i] = i;
            if (!this.seleccionado[i]) continue;
            info_gain[i] = infoG - this.infoGcondi(i, ejemplos, nEjemplos);
            ++n;
        }
        if (n > 2) {
            for (i = 0; i < this.antecedente.length - 1; ++i) {
                if (!this.seleccionado[i]) continue;
                for (int j = i + 1; j < this.antecedente.length; ++j) {
                    if (!this.seleccionado[j] || !(info_gain[i] > info_gain[j])) continue;
                    double temp = info_gain[i];
                    info_gain[i] = info_gain[j];
                    info_gain[j] = temp;
                    int temp2 = atributos[i];
                    atributos[i] = atributos[j];
                    atributos[j] = temp2;
                }
            }
            for (i = 0; i < this.antecedente.length && n > 2; ++i) {
                if (!this.seleccionado[i] || !(Randomize.Rand() > info_gain[i])) continue;
                this.seleccionado[i] = false;
                --n;
            }
        }
    }

    public void pruning(double[] norm_acc) {
        int i;
        int[] atributos = new int[this.antecedente.length];
        int n = 0;
        for (i = 0; i < this.antecedente.length; ++i) {
            atributos[i] = i;
            if (!this.seleccionado[i]) continue;
            ++n;
        }
        if (n > 2) {
            for (i = 0; i < this.antecedente.length - 1; ++i) {
                if (!this.seleccionado[i]) continue;
                for (int j = i + 1; j < this.antecedente.length; ++j) {
                    if (!this.seleccionado[j] || !(norm_acc[i] > norm_acc[j])) continue;
                    double temp = norm_acc[i];
                    norm_acc[i] = norm_acc[j];
                    norm_acc[j] = temp;
                    int temp2 = atributos[i];
                    atributos[i] = atributos[j];
                    atributos[j] = temp2;
                }
            }
            for (i = 0; i < this.antecedente.length && n > 2; ++i) {
                if (!this.seleccionado[i] || !(Randomize.Rand() > norm_acc[i])) continue;
                this.seleccionado[i] = false;
                --n;
            }
        }
    }

    public int compareTo(Object a) {
        if (((Individuo)a).fitness < this.fitness) {
            return -1;
        }
        if (((Individuo)a).fitness > this.fitness) {
            return 1;
        }
        return 0;
    }
}

