/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe;

import cc.mallet.pipe.Pipe;
import cc.mallet.pipe.SerialPipes;
import cc.mallet.types.Alphabet;

public class PipeUtils {
    private PipeUtils() {
    }

    public static Pipe concatenatePipes(Pipe p1, Pipe p2) {
        Alphabet dataDict = PipeUtils.combinedDataDicts(p1, p2);
        Alphabet targetDict = PipeUtils.combinedTargetDicts(p1, p2);
        SerialPipes ret = new SerialPipes(new Pipe[]{p1, p2});
        if (dataDict != null) {
            ret.dataAlphabetResolved = true;
        }
        if (targetDict != null) {
            ret.targetAlphabetResolved = true;
        }
        ret.dataAlphabet = dataDict;
        ret.targetAlphabet = targetDict;
        return ret;
    }

    private static Alphabet combinedDataDicts(Pipe p1, Pipe p2) {
        if (p1.dataAlphabet == null) {
            return p2.dataAlphabet;
        }
        if (p2.dataAlphabet == null) {
            return p1.dataAlphabet;
        }
        if (p1.dataAlphabet == p2.dataAlphabet) {
            return p2.dataAlphabet;
        }
        throw new IllegalArgumentException("Attempt to concat pipes with incompatible data dicts.");
    }

    private static Alphabet combinedTargetDicts(Pipe p1, Pipe p2) {
        if (p1.targetAlphabet == null) {
            return p2.targetAlphabet;
        }
        if (p2.targetAlphabet == null) {
            return p1.targetAlphabet;
        }
        if (p1.targetAlphabet == p2.targetAlphabet) {
            return p2.targetAlphabet;
        }
        throw new IllegalArgumentException("Attempt to concat pipes with incompatible target dicts.");
    }
}

