/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe;

import cc.mallet.extract.StringSpan;
import cc.mallet.extract.StringTokenization;
import cc.mallet.pipe.SimpleTaggerSentence2TokenSequence;
import cc.mallet.types.Instance;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.LabelSequence;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SimpleTaggerSentence2StringTokenization
extends SimpleTaggerSentence2TokenSequence {
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public SimpleTaggerSentence2StringTokenization() {
    }

    public SimpleTaggerSentence2StringTokenization(boolean inc) {
        super(inc);
    }

    @Override
    public Instance pipe(Instance carrier) {
        String[][] tokens;
        Object inputData = carrier.getData();
        LabelSequence target = null;
        StringBuffer source = new StringBuffer();
        StringTokenization ts = new StringTokenization(source);
        if (inputData instanceof String) {
            tokens = this.parseSentence((String)inputData);
        } else if (inputData instanceof String[][]) {
            tokens = (String[][])inputData;
        } else {
            throw new IllegalArgumentException("Not a String; got " + inputData);
        }
        if (this.isTargetProcessing()) {
            LabelAlphabet labels = (LabelAlphabet)this.getTargetAlphabet();
            target = new LabelSequence(labels, tokens.length);
        }
        for (int l = 0; l < tokens.length; ++l) {
            int f;
            int nFeatures;
            if (this.isTargetProcessing()) {
                if (tokens[l].length < 1) {
                    throw new IllegalStateException("Missing label at line " + l + " instance " + carrier.getName());
                }
                nFeatures = tokens[l].length - 1;
                target.add(tokens[l][nFeatures]);
            } else {
                nFeatures = tokens[l].length;
            }
            int start = source.length();
            String word = this.makeText(tokens[l]);
            source.append(word + " ");
            StringSpan tok = new StringSpan(source, start, source.length() - 1);
            if (this.setTokensAsFeatures) {
                for (f = 0; f < nFeatures; ++f) {
                    tok.setFeatureValue(tokens[l][f], 1.0);
                }
            } else {
                for (f = 1; f < nFeatures; ++f) {
                    tok.setFeatureValue(tokens[l][f], 1.0);
                }
            }
            ts.add(tok);
        }
        carrier.setData(ts);
        if (this.isTargetProcessing()) {
            carrier.setTarget(target);
        }
        return carrier;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(1);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int version = in.readInt();
    }
}

