### R code from vignette source 'oc.Rnw'

###################################################
### code chunk number 1: one
###################################################
library(oc)
#sen90 <- readKH("https://voteview.com/static/data/out/votes/S090_votes.ord")
data(sen90)     #Does same thing as above
sen90


###################################################
### code chunk number 2: oneandhalf
###################################################
selector <- c(21,22,44,45,46,47,48,49,50,53,54,55,56,58,59,60,61,62,65,66,67,68,69,70,71,72,73,74,75,77,78,80,81,82,83,84,87,99,100,101,105,118,119,120,128,129,130,131,132,133,134,135,141,142,143,144,145,147,149,151,204,209,211,218,219,220,221,222,223,224,225,226,227,228,229,237,238,239,252,253,257,260,261,265,266,268,269,270,276,281,290,292,293,294,295,296,302,309,319,321,322,323,324,325,327,330,331,332,333,335,336,337,339,340,346,347,357,359,367,375,377,378,379,381,384,386,392,393,394,405,406,410,418,427,437,442,443,444,448,449,450,454,455,456,459,460,461,464,465,467,481,487,489,490,491,492,493,495,497,501,502,503,504,505,506,507,514,515,522,523,529,539,540,541,542,543,544,546,548,549,550,551,552,553,554,555,556,557,558,559,560,561,562,565,566,567,568,569,571,584,585,586,589,590,592,593,594,595)

sen90$m <- length(selector)
sen90$votes <- sen90$votes[,selector]


###################################################
### code chunk number 3: two
###################################################
rownames(sen90$votes)[1:12]
result <- oc(sen90, polarity=c(2,5))


###################################################
### code chunk number 4: three
###################################################
summary(result)


###################################################
### code chunk number 5: four
###################################################
plot(result)


###################################################
### code chunk number 6: five
###################################################
par(mfrow=c(1,1))
plot.OCcoords(result,cutline=14)


###################################################
### code chunk number 7: UN1
###################################################
rm(list=ls(all=TRUE))
data(UN)
UN<-as.matrix(UN)
UN[1:5,1:6]


###################################################
### code chunk number 8: UN2
###################################################
UNnames<-UN[,1]
legData<-matrix(UN[,2],length(UN[,2]),1)
colnames(legData)<-"party"
UN<-UN[,-c(1,2)]


###################################################
### code chunk number 9: UN3
###################################################
rc <- rollcall(UN, yea=c(1,2,3), nay=c(4,5,6),
missing=c(7,8,9),notInLegis=0, legis.names=UNnames,
legis.data=legData,
desc="UN Votes",
source="legacy.voteview.com")
result<-oc(rc,polarity=1,dims=1)


###################################################
### code chunk number 10: UN5
###################################################
summary(result)


###################################################
### code chunk number 11: UN4
###################################################
plot(result)


