/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing;

import com.qarks.util.ui.swing.events.ClickEvent;
import com.qarks.util.ui.swing.events.ClickListener;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.SwingUtilities;

public class ContainerClickManager {
    private static Map<Container, AWTEventListener> listeners = new Hashtable<Container, AWTEventListener>();

    public static void removeClickListener(Container container) {
        AWTEventListener aWTEventListener = listeners.get(container);
        if (aWTEventListener != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(aWTEventListener);
            listeners.remove(container);
        }
    }

    public static void addClickListener(final Container container, final ClickListener clickListener) {
        AWTEventListener aWTEventListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent aWTEvent) {
                if (aWTEvent instanceof MouseEvent) {
                    MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                    boolean bl = ContainerClickManager.isIncluded(container, mouseEvent);
                    if (mouseEvent.getID() == 502) {
                        Serializable serializable;
                        if (bl) {
                            Window window;
                            serializable = SwingUtilities.getWindowAncestor((Component)aWTEvent.getSource());
                            bl = serializable == (window = SwingUtilities.getWindowAncestor(container));
                        }
                        serializable = new ClickEvent(mouseEvent.getSource(), ClickEvent.Type.CLICK, bl);
                        ContainerClickManager.sendLater(clickListener, (ClickEvent)serializable);
                    } else if (mouseEvent.getID() == 503) {
                        ClickEvent clickEvent = new ClickEvent(mouseEvent.getSource(), ClickEvent.Type.MOVE, bl);
                        ContainerClickManager.sendLater(clickListener, clickEvent);
                    }
                }
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(aWTEventListener, 48L);
        listeners.put(container, aWTEventListener);
    }

    public static void removeClickListener(Container container, ClickListener clickListener) {
        AWTEventListener aWTEventListener = listeners.remove(container);
        if (aWTEventListener != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(aWTEventListener);
        }
    }

    private static void sendLater(final ClickListener clickListener, final ClickEvent clickEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                clickListener.onClick(clickEvent);
            }
        });
    }

    public static boolean isIncluded(Container container, MouseEvent mouseEvent) {
        boolean bl = false;
        if (container.isShowing()) {
            Point point = mouseEvent.getLocationOnScreen();
            Point point2 = container.getLocationOnScreen();
            Dimension dimension = container.getSize();
            if (point.x > point2.x && point.x < point2.x + dimension.width && point.y > point2.y && point.y < point2.y + dimension.height) {
                bl = true;
            }
        }
        return bl;
    }
}

