/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.binary;

import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.binary.CouplesBitSetTable;
import org.chocosolver.solver.constraints.extension.binary.PropBinCSP;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableBitSet;

public class PropBinAC3
extends PropBinCSP {
    private final IntIterableBitSet vrms = new IntIterableBitSet();

    public PropBinAC3(IntVar x, IntVar y, Tuples tuples) {
        this(x, y, new CouplesBitSetTable(tuples, x, y));
    }

    private PropBinAC3(IntVar x, IntVar y, CouplesBitSetTable table) {
        super(x, y, table);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.reviseV0();
        this.reviseV1();
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (idxVarInProp == 0) {
            this.reviseV1();
        } else {
            this.reviseV0();
        }
    }

    private void reviseV1() throws ContradictionException {
        int nbs = 0;
        this.vrms.clear();
        this.vrms.setOffset(this.v1.getLB());
        DisposableValueIterator itv1 = this.v1.getValueIterator(true);
        while (itv1.hasNext()) {
            int val1 = itv1.next();
            DisposableValueIterator itv0 = this.v0.getValueIterator(true);
            while (itv0.hasNext()) {
                int val0 = itv0.next();
                if (!this.relation.isConsistent(val0, val1)) continue;
                ++nbs;
                break;
            }
            itv0.dispose();
            if (nbs == 0) {
                this.vrms.add(val1);
            }
            nbs = 0;
        }
        this.v1.removeValues(this.vrms, this);
        itv1.dispose();
    }

    private void reviseV0() throws ContradictionException {
        int nbs = 0;
        this.vrms.clear();
        this.vrms.setOffset(this.v0.getLB());
        DisposableValueIterator itv0 = this.v0.getValueIterator(true);
        while (itv0.hasNext()) {
            int val0 = itv0.next();
            DisposableValueIterator itv1 = this.v1.getValueIterator(true);
            while (itv1.hasNext()) {
                int val1 = itv1.next();
                if (!this.relation.isConsistent(val0, val1)) continue;
                ++nbs;
                break;
            }
            itv1.dispose();
            if (nbs == 0) {
                this.vrms.add(val0);
            }
            nbs = 0;
        }
        this.v0.removeValues(this.vrms, this);
        itv0.dispose();
    }
}

