/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model.transform;

import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.MarshallLocation;
import com.simba.athena.amazonaws.protocol.MarshallingInfo;
import com.simba.athena.amazonaws.protocol.MarshallingType;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.services.glue.model.Segment;

@SdkInternalApi
public class SegmentMarshaller {
    private static final MarshallingInfo<Integer> SEGMENTNUMBER_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SegmentNumber").build();
    private static final MarshallingInfo<Integer> TOTALSEGMENTS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalSegments").build();
    private static final SegmentMarshaller instance = new SegmentMarshaller();

    public static SegmentMarshaller getInstance() {
        return instance;
    }

    public void marshall(Segment segment, ProtocolMarshaller protocolMarshaller) {
        if (segment == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(segment.getSegmentNumber(), SEGMENTNUMBER_BINDING);
            protocolMarshaller.marshall(segment.getTotalSegments(), TOTALSEGMENTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

