/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.jdbc.common;

import com.simba.athena.dsi.core.interfaces.IConnection;
import com.simba.athena.dsi.core.interfaces.IStatement;
import com.simba.athena.exceptions.JDBCMessageKey;
import com.simba.athena.jdbc.common.SCallableStatement;
import com.simba.athena.jdbc.common.SConnection;
import com.simba.athena.jdbc.common.SConnectionHandle;
import com.simba.athena.jdbc.common.SDatabaseMetaData;
import com.simba.athena.jdbc.common.SPooledConnection;
import com.simba.athena.jdbc.common.SPreparedStatement;
import com.simba.athena.jdbc.common.SStatement;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.exceptions.GeneralException;
import java.sql.SQLException;
import javax.sql.PooledConnection;

public abstract class JDBCObjectFactory {
    private static JDBCObjectFactory s_factory = null;

    static JDBCObjectFactory getInstance() {
        return s_factory;
    }

    static void setInstance(JDBCObjectFactory jDBCObjectFactory) throws GeneralException {
        if (null == jDBCObjectFactory) {
            throw new GeneralException(1, JDBCMessageKey.INITIALIZE_FACTORY.name());
        }
        s_factory = jDBCObjectFactory;
    }

    protected JDBCObjectFactory() {
    }

    protected abstract SCallableStatement createCallableStatement(String var1, IStatement var2, SConnection var3, int var4) throws SQLException;

    protected abstract SConnection createConnection(IConnection var1, String var2) throws SQLException;

    protected abstract SConnectionHandle createConnectionHandle(SConnection var1, SPooledConnection var2) throws SQLException;

    protected abstract SDatabaseMetaData createDatabaseMetaData(SConnection var1, ILogger var2) throws SQLException;

    protected abstract SPreparedStatement createPreparedStatement(String var1, IStatement var2, SConnection var3, int var4) throws SQLException;

    protected abstract PooledConnection createPooledConnection(SConnection var1) throws SQLException;

    protected abstract SStatement createStatement(IStatement var1, SConnection var2, int var3) throws SQLException;
}

