/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.SQLType;
import java.util.ArrayList;
import java.util.List;
import oracle.jdbc.OracleShardingKeyBuilder;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OracleShardingKeyImpl;

@DefaultLogger(value="oracle.jdbc.pool")
@Supports(value={Feature.CONN_POOL})
public class OracleShardingKeyBuilderImpl
implements OracleShardingKeyBuilder {
    private final List<Object> subKeyObjects = new ArrayList<Object>();
    private final List<SQLType> subKeyTypes = new ArrayList<SQLType>();
    private long oraHash = 0L;
    private boolean isBuilt = false;

    @Override
    public OracleShardingKeyBuilderImpl subkey(Object object, SQLType sQLType) {
        if (object == null) {
            throw new IllegalArgumentException("Null sharding key is not allowed");
        }
        this.subKeyObjects.add(object);
        this.subKeyTypes.add(sQLType);
        return this;
    }

    public OracleShardingKeyBuilderImpl oraHash(long l2) {
        this.oraHash = l2;
        return this;
    }

    @Override
    public OracleShardingKeyImpl build() {
        if (this.isBuilt) {
            throw new IllegalStateException("build() method can be used only once on a builder object");
        }
        this.isBuilt = true;
        return new OracleShardingKeyImpl(this);
    }

    List<Object> subKeyObjects() {
        return this.subKeyObjects;
    }

    List<SQLType> subKeyTypes() {
        return this.subKeyTypes;
    }

    long getOraHash() {
        return this.oraHash;
    }
}

