/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.portfolio;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.portfolioeffect.quant.client.ClientConnection;
import com.portfolioeffect.quant.client.portfolio.ArrayCache;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PortfolioData {
    private static final HashSet<String> estimatorParams = new HashSet();
    private static final HashSet<String> portfoliorParams = new HashSet();
    private boolean isNaNFiltered = true;
    private boolean isNaN2Zero = false;
    private HashMap<String, String> estimatorSettings;
    private HashMap<String, String> portfolioSettings;
    private HashMap<String, ArrayCache> symbolQuantityMap = new HashMap();
    private HashMap<String, ArrayCache> symbolQuantityTimeMap;
    private HashMap<String, ArrayCache> symbolPriceMap;
    private HashMap<String, ArrayCache> symbolPriceTimeMap;
    private List<String> symbolNamesList;
    private long dataId;
    private ArrayCache indexPrice;
    private ArrayCache indexTimeMillisec;
    private HashMap<String, Long> priceID;
    private HashMap<String, Long> quantityID;
    private Set<String> userPrice;

    protected void finalize() throws Throwable {
        this.symbolQuantityMap.clear();
        this.symbolQuantityTimeMap.clear();
        this.symbolPriceMap.clear();
        this.symbolPriceTimeMap.clear();
        super.finalize();
    }

    public PortfolioData(PortfolioData data) throws IOException {
        for (String e : data.symbolQuantityMap.keySet()) {
            this.symbolQuantityMap.put(e, new ArrayCache(data.symbolQuantityMap.get(e).getIntArray()));
        }
        this.symbolQuantityTimeMap = new HashMap();
        for (String e : data.symbolQuantityTimeMap.keySet()) {
            this.symbolQuantityTimeMap.put(e, new ArrayCache(data.symbolQuantityTimeMap.get(e).getLongArray()));
        }
        this.symbolPriceMap = new HashMap();
        for (String e : data.symbolPriceMap.keySet()) {
            this.symbolPriceMap.put(e, new ArrayCache(data.symbolPriceMap.get(e).getDoubleArray()));
        }
        this.symbolPriceTimeMap = new HashMap();
        for (String e : data.symbolPriceTimeMap.keySet()) {
            this.symbolPriceTimeMap.put(e, new ArrayCache(data.symbolPriceTimeMap.get(e).getLongArray()));
        }
        this.symbolNamesList = new ArrayList<String>(data.symbolNamesList);
        this.dataId = data.dataId;
        if (data.indexPrice != null) {
            this.indexPrice = new ArrayCache(data.indexPrice.getDoubleArray());
        }
        if (data.indexTimeMillisec != null) {
            this.indexTimeMillisec = new ArrayCache(data.indexTimeMillisec.getLongArray());
        }
        this.priceID = new HashMap<String, Long>(data.priceID);
        this.quantityID = new HashMap<String, Long>(data.quantityID);
        this.userPrice = new HashSet<String>(data.userPrice);
        this.estimatorSettings = new HashMap<String, String>(data.estimatorSettings);
        this.portfolioSettings = new HashMap<String, String>(data.portfolioSettings);
        this.estimatorSettings.put("portfolioId", "" + ClientConnection.getNewId());
    }

    public PortfolioData() {
        this.symbolQuantityTimeMap = new HashMap();
        this.symbolPriceMap = new HashMap();
        this.symbolPriceTimeMap = new HashMap();
        this.symbolNamesList = new ArrayList<String>();
        this.estimatorSettings = new HashMap();
        this.portfolioSettings = new HashMap();
        this.portfolioSettings.put("windowLength", "1d");
        this.estimatorSettings.put("fromTime", "#");
        this.estimatorSettings.put("toTime", "#");
        this.dataId = 0L;
        this.estimatorSettings.put("portfolioId", "" + ClientConnection.getNewId());
        this.indexPrice = null;
        this.indexTimeMillisec = null;
        this.priceID = new HashMap();
        this.quantityID = new HashMap();
        this.userPrice = new HashSet<String>();
    }

    public String getIndexSymbol() {
        return this.estimatorSettings.get("indexSymbol");
    }

    public void setIndexSymbol(String indexSymbol) {
        this.estimatorSettings.put("indexSymbol", indexSymbol);
    }

    public HashMap<String, ArrayCache> getSymbolQuantityMap() {
        return this.symbolQuantityMap;
    }

    public void setSymbolQuantityMap(HashMap<String, ArrayCache> symbolQuantityMap) {
        this.symbolQuantityMap = symbolQuantityMap;
    }

    public HashMap<String, ArrayCache> getSymbolQuantityTimeMap() {
        return this.symbolQuantityTimeMap;
    }

    public void setSymbolQuantityTimeMap(HashMap<String, ArrayCache> symbolQuantityTimeMap) {
        this.symbolQuantityTimeMap = symbolQuantityTimeMap;
    }

    public HashMap<String, ArrayCache> getSymbolPriceMap() {
        return this.symbolPriceMap;
    }

    public void setSymbolPriceMap(HashMap<String, ArrayCache> symbolPriceMap) {
        this.symbolPriceMap = symbolPriceMap;
    }

    public HashMap<String, ArrayCache> getSymbolPriceTimeMap() {
        return this.symbolPriceTimeMap;
    }

    public void setSymbolPriceTimeMap(HashMap<String, ArrayCache> symbolPriceTimeMap) {
        this.symbolPriceTimeMap = symbolPriceTimeMap;
    }

    public List<String> getSymbolNamesList() {
        return this.symbolNamesList;
    }

    public void setSymbolNamesList(List<String> symbolNamesList) {
        this.symbolNamesList = symbolNamesList;
    }

    public String getFromTime() {
        return this.estimatorSettings.get("fromTime");
    }

    public void setFromTime(String fromTime) {
        this.estimatorSettings.put("fromTime", fromTime);
    }

    public String getToTime() {
        return this.estimatorSettings.get("toTime");
    }

    public void setToTime(String toTime) {
        this.estimatorSettings.put("toTime", toTime);
    }

    public long getDataId() {
        return this.dataId;
    }

    public void setDataId(int dataId) {
        this.dataId = dataId;
    }

    public long getPortfolioId() {
        return Long.valueOf(this.estimatorSettings.get("portfolioId"));
    }

    public void setPortfolioId(long portfolioId) {
        this.estimatorSettings.put("portfolioId", "" + ClientConnection.getNewId());
    }

    public ArrayCache getIndexPrice() {
        return this.indexPrice;
    }

    public void setIndexPrice(ArrayCache indexPrice) {
        this.indexPrice = indexPrice;
    }

    public ArrayCache getIndexTimeMillisec() {
        return this.indexTimeMillisec;
    }

    public void setIndexTimeMillisec(ArrayCache indexTimeMillisec) {
        this.indexTimeMillisec = indexTimeMillisec;
    }

    public HashMap<String, Long> getPriceID() {
        return this.priceID;
    }

    public void setPriceID(HashMap<String, Long> priceID) {
        this.priceID = priceID;
    }

    public HashMap<String, Long> getQuantityID() {
        return this.quantityID;
    }

    public void setQuantityID(HashMap<String, Long> quantityID) {
        this.quantityID = quantityID;
    }

    public long getNextDataId() {
        return this.dataId++;
    }

    public Set<String> getUserPrice() {
        return this.userPrice;
    }

    public void setUserPrice(Set<String> userPrice) {
        this.userPrice = userPrice;
    }

    public HashMap<String, String> getSettingsReal() {
        HashMap<String, String> settings = new HashMap<String, String>();
        for (Map.Entry<String, String> e : this.estimatorSettings.entrySet()) {
            settings.put(e.getKey(), e.getValue());
        }
        for (Map.Entry<String, String> e : this.portfolioSettings.entrySet()) {
            settings.put(e.getKey(), e.getValue());
        }
        return settings;
    }

    public HashMap<String, String> getSettings() {
        HashMap<String, String> settings = new HashMap<String, String>();
        for (Map.Entry<String, String> e : this.estimatorSettings.entrySet()) {
            settings.put(this.renameParamsInverse(e.getKey()), e.getValue());
        }
        for (Map.Entry<String, String> e : this.portfolioSettings.entrySet()) {
            settings.put(this.renameParamsInverse(e.getKey()), e.getValue());
        }
        return settings;
    }

    public HashMap<String, String> getPortfolioSettings() {
        return this.portfolioSettings;
    }

    public HashMap<String, String> getEstimatorSettings() {
        return this.estimatorSettings;
    }

    private String renameParams(String param) {
        if (param.equals("holdingPeriodsOnly")) {
            return "isHoldingPeriodEnabled";
        }
        if (param.equals("noiseModel")) {
            return "isNoiseModelEnabled";
        }
        if (param.equals("fractalPriceModel")) {
            return "isFractalPriceModelEnabled";
        }
        if (param.equals("densityModel")) {
            return "densityApproxModel";
        }
        if (param.equals("driftTerm")) {
            return "isDriftEnabled";
        }
        if (param.equals("resultsSamplingInterval")) {
            return "samplingInterval";
        }
        if (param.equals("inputSamplingInterval")) {
            return "priceSamplingInterval";
        }
        return param;
    }

    private String renameParamsInverse(String param) {
        if (param.equals("isHoldingPeriodEnabled")) {
            return "holdingPeriodsOnly";
        }
        if (param.equals("isNoiseModelEnabled")) {
            return "noiseModel";
        }
        if (param.equals("isFractalPriceModelEnabled")) {
            return "fractalPriceModel";
        }
        if (param.equals("densityApproxModel")) {
            return "densityModel";
        }
        if (param.equals("isDriftEnabled")) {
            return "driftTerm";
        }
        if (param.equals("samplingInterval")) {
            return "resultsSamplingInterval";
        }
        if (param.equals("priceSamplingInterval")) {
            return "inputSamplingInterval";
        }
        return param;
    }

    public void setParam(String key, String value) {
        if (key.equals("resultsNAFilter")) {
            this.setNaNFiltered(value.equals("true"));
            return;
        }
        if (estimatorParams.contains(key = this.renameParams(key))) {
            this.estimatorSettings.put(key, value);
        } else {
            this.portfolioSettings.put(key, value);
        }
    }

    public void removeParam(String key) {
        if (estimatorParams.contains(key)) {
            this.estimatorSettings.remove(key);
        } else {
            this.portfolioSettings.remove(key);
        }
    }

    public boolean containsParam(String key) {
        if (estimatorParams.contains(key)) {
            return this.estimatorSettings.containsKey(key);
        }
        return this.portfolioSettings.containsKey(key);
    }

    public String getParam(String key) {
        if (key.equals("resultsNAFilter")) {
            return "" + this.isNaNFiltered;
        }
        if (estimatorParams.contains(key)) {
            return this.estimatorSettings.get(key);
        }
        return this.portfolioSettings.get(key);
    }

    public void setSettings(HashMap<String, String> settings) {
        for (Map.Entry<String, String> e : settings.entrySet()) {
            this.setParam(e.getKey(), e.getValue());
        }
    }

    public void setSettingJSON(String JSONString) {
        Gson gson = new Gson();
        Type mapType = new TypeToken<HashMap<String, String>>(){}.getType();
        HashMap newSettings = (HashMap)gson.fromJson(JSONString, mapType);
        this.setSettings(newSettings);
    }

    public String getSettingJSON() {
        Gson gson = new Gson();
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.putAll(this.estimatorSettings);
        settings.putAll(this.portfolioSettings);
        return gson.toJson(settings);
    }

    public boolean isNaNFiltered() {
        return this.isNaNFiltered;
    }

    public void setNaNFiltered(boolean isNaNFiltered) {
        this.isNaNFiltered = isNaNFiltered;
    }

    public boolean isNaN2Zero() {
        return this.isNaN2Zero;
    }

    public void setNaN2Zero(boolean isNaN2Zero) {
        this.isNaN2Zero = isNaN2Zero;
    }

    public boolean checkEstimatorParams(String params) {
        return estimatorParams.contains(params);
    }

    public boolean checkPortfolioParams(String params) {
        return estimatorParams.contains(params) || portfoliorParams.contains(params);
    }

    public void setPortfolioSettings(HashMap<String, String> portfolioSettings) {
        this.portfolioSettings = portfolioSettings;
    }

    public void setEstimatorSettings(HashMap<String, String> estimatorSettings) {
        this.estimatorSettings = estimatorSettings;
    }

    static {
        estimatorParams.add("fromTime");
        estimatorParams.add("toTime");
        estimatorParams.add("portfolioId");
        estimatorParams.add("indexSymbol");
        estimatorParams.add("spotWindowLength");
        estimatorParams.add("timeScale");
        estimatorParams.add("samplingInterval");
        estimatorParams.add("priceSamplingInterval");
        estimatorParams.add("jumpsModel");
        estimatorParams.add("isNoiseModelEnabled");
        estimatorParams.add("isFractalPriceModelEnabled");
        estimatorParams.add("isStartWhenBurn");
        estimatorParams.add("synchronizationModel");
        estimatorParams.add("riskMethodology");
        estimatorParams.add("stream");
        estimatorParams.add("trainingModel");
        portfoliorParams.add("windowLength");
        portfoliorParams.add("portfolioId");
        portfoliorParams.add("shortSalesMode");
        portfoliorParams.add("isHoldingPeriodEnabled");
        portfoliorParams.add("isRebalancingHistoryEnabled");
        portfoliorParams.add("isDriftEnabled");
        portfoliorParams.add("txnCostFixed");
        portfoliorParams.add("txnCostPerShare");
        portfoliorParams.add("densityApproxModel");
        portfoliorParams.add("isNoBurnMoment");
        portfoliorParams.add("portfolioMetricsMode");
    }
}

