/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.util;

import com.google.gson.Gson;
import com.portfolioeffect.quant.client.type.MetricsTypeFull;
import java.util.HashMap;

public class MetricStringBuilder {
    private HashMap<String, String> map = new HashMap();

    public MetricStringBuilder setMetric(String metric) {
        this.map.put("metric", "" + metric);
        return this;
    }

    public MetricStringBuilder setMetric(MetricsTypeFull metric) {
        this.map.put("metric", "" + (Object)((Object)metric));
        return this;
    }

    public MetricStringBuilder setPosition(String position) {
        this.map.put("position", position);
        return this;
    }

    public MetricStringBuilder setWindowLength(String windowLength) {
        this.map.put("windowLength", windowLength);
        return this;
    }

    public MetricStringBuilder setSortDirection(String sortDirection) {
        this.map.put("sort_direction", sortDirection);
        return this;
    }

    public MetricStringBuilder setSortDirectionToAscending() {
        this.map.put("sort_direction", "ascending");
        return this;
    }

    public MetricStringBuilder setSortDirectionToDescending() {
        this.map.put("sort_direction", "descending");
        return this;
    }

    public MetricStringBuilder setValue(String metric) {
        this.map.put("value", "" + metric);
        return this;
    }

    public MetricStringBuilder setSortBy(String metric) {
        this.map.put("sort_by", "" + metric);
        return this;
    }

    public MetricStringBuilder setConfidenceInterval(double confidenceInterval) {
        this.map.put("confidenceInterval", "" + confidenceInterval);
        return this;
    }

    public MetricStringBuilder setConfidenceIntervalAlphaBeta(double confidenceIntervalAlpha, double confidenceIntervalBeta) {
        this.map.put("confidenceIntervalAlpha", "" + confidenceIntervalAlpha);
        this.map.put("confidenceIntervalBeta", "" + confidenceIntervalBeta);
        return this;
    }

    public MetricStringBuilder setPositionA(String position) {
        this.map.put("positionA", position);
        return this;
    }

    public MetricStringBuilder setPositionB(String position) {
        this.map.put("positionB", position);
        return this;
    }

    public MetricStringBuilder setLag(int lag) {
        this.map.put("lag", "" + lag);
        return this;
    }

    public MetricStringBuilder setThresholdReturn(double thresholdReturn) {
        this.map.put("thresholdReturn", "" + thresholdReturn);
        return this;
    }

    public MetricStringBuilder reset() {
        this.map.clear();
        return this;
    }

    public String getJSON() {
        Gson gson = new Gson();
        return gson.toJson(this.map);
    }

    public HashMap<String, String> getMap() {
        return this.map;
    }
}

