/*
 * Decompiled with CFR 0.152.
 */
package jd2.workspace.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import jd2.workspace.io.IO;
import jd2.workspace.io.Jaxb;
import jd2.workspace.io.Xml;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class JaxbUtil {
    public static @NonNull Object unmarshal(@NonNull Path file, @NonNull JAXBContext context) throws JAXBException, IOException {
        try {
            return Jaxb.Parser.of(context).parsePath(file);
        }
        catch (Xml.WrappedException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof JAXBException) {
                throw (JAXBException)cause;
            }
            throw ex;
        }
    }

    public static @NonNull Object unmarshal(@NonNull Path file, @NonNull Unmarshaller unmarshaller) throws JAXBException, IOException {
        try {
            return Jaxb.Parser.builder().factory(() -> unmarshaller).build().parsePath(file);
        }
        catch (Xml.WrappedException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof JAXBException) {
                throw (JAXBException)cause;
            }
            throw ex;
        }
    }

    public static void marshal(@NonNull Path file, @NonNull JAXBContext context, @NonNull Object jaxbElement, boolean formatted) throws JAXBException, IOException {
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)formatted);
        JaxbUtil.marshal(file, marshaller, jaxbElement);
    }

    public static void marshal(@NonNull Path file, @NonNull Marshaller marshaller, @NonNull Object jaxbElement) throws JAXBException, IOException {
        Optional<File> localFile = IO.getFile(file);
        if (localFile.isPresent()) {
            marshaller.marshal(jaxbElement, localFile.get());
        } else {
            try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
                marshaller.marshal(jaxbElement, (Writer)writer);
            }
        }
    }

    public static @NonNull JAXBContext createContext(@NonNull Class<?> type) {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{type});
        }
        catch (JAXBException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <X> void forSingle(@Nullable X item, @NonNull Consumer<? super X> action) {
        Objects.requireNonNull(action, "action");
        if (item != null) {
            action.accept(item);
        }
    }

    public static <X> void forEach(@Nullable X[] array, @NonNull Consumer<? super X> action) {
        Objects.requireNonNull(action, "action");
        if (array != null) {
            for (X o : array) {
                action.accept(o);
            }
        }
    }

    private JaxbUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

