/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.simplets;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import ec.tstoolkit.utilities.WeightedItem;
import java.util.ArrayList;

public class TsAggregator {
    private boolean zero_;
    private boolean normalize_;
    private final ArrayList<WeightedItem<TsData>> items_ = new ArrayList();

    public void add(TsData s) {
        this.items_.add(new WeightedItem<TsData>(s));
    }

    public void add(TsData s, double weight) {
        this.items_.add(new WeightedItem<TsData>(s, weight));
    }

    public void addRange(Iterable<TsData> s) {
        for (TsData t : s) {
            this.items_.add(new WeightedItem<TsData>(t));
        }
    }

    public void clear() {
        this.items_.clear();
    }

    public int getCount() {
        return this.items_.size();
    }

    public TsDomain getIntersectionDomain() {
        int nts = this.items_.size();
        if (nts == 0) {
            return null;
        }
        TsDomain dom = ((TsData)this.items_.get((int)0).item).getDomain();
        for (int i = 1; i < nts; ++i) {
            if ((dom = dom.intersection(((TsData)this.items_.get((int)i).item).getDomain())) != null) continue;
            return null;
        }
        return dom;
    }

    public TsDomain getUnionDomain() {
        int nts = this.items_.size();
        if (nts == 0) {
            return null;
        }
        TsDomain dom = ((TsData)this.items_.get((int)0).item).getDomain();
        for (int i = 1; i < nts; ++i) {
            if ((dom = dom.union(((TsData)this.items_.get((int)i).item).getDomain())) != null) continue;
            return null;
        }
        return dom;
    }

    public boolean isMissingsEqualsToZero() {
        return this.zero_;
    }

    public boolean isRescalingWeights() {
        return this.normalize_;
    }

    private void nwsum(TsData total) {
        block6: {
            int nts;
            TsDomain dom;
            block5: {
                int i;
                dom = total.getDomain();
                nts = this.items_.size();
                if (!this.zero_) break block5;
                double w = 0.0;
                for (i = 0; i < nts; ++i) {
                    w += this.items_.get((int)i).weight;
                }
                if (w == 0.0) break block6;
                for (i = 0; i < dom.getLength(); ++i) {
                    double s = 0.0;
                    TsPeriod p = dom.get(i);
                    for (int j = 0; j < nts; ++j) {
                        WeightedItem<TsData> cur = this.items_.get(j);
                        double curw = cur.weight;
                        int idx = ((TsData)cur.item).getDomain().search(p);
                        if (idx < 0) continue;
                        s += curw * ((TsData)cur.item).get(idx);
                    }
                    total.set(i, s / w);
                }
                break block6;
            }
            for (int i = 0; i < dom.getLength(); ++i) {
                double s = 0.0;
                double w = 0.0;
                TsPeriod p = dom.get(i);
                for (int j = 0; j < nts; ++j) {
                    WeightedItem<TsData> cur = this.items_.get(j);
                    double curw = cur.weight;
                    int idx = ((TsData)cur.item).getDomain().search(p);
                    if (idx < 0) continue;
                    s += curw * ((TsData)cur.item).get(idx);
                    w += curw;
                }
                if (w == 0.0) continue;
                total.set(i, s / w);
            }
        }
    }

    public void setMissingsEqualsToZero(boolean value) {
        this.zero_ = value;
    }

    public void setRescalingWeights(boolean value) {
        this.normalize_ = value;
    }

    public TsData sum() {
        int nts = this.items_.size();
        if (nts == 0) {
            return null;
        }
        if (nts == 1) {
            return this.witem(0);
        }
        TsDomain dom = this.zero_ || this.normalize_ ? this.getUnionDomain() : this.getIntersectionDomain();
        TsData total = new TsData(dom);
        total.set(() -> 0.0);
        if (this.normalize_) {
            this.nwsum(total);
        } else {
            this.sum(total);
        }
        return total;
    }

    private void sum(TsData total) {
        TsDomain dom = total.getDomain();
        double[] x = total.internalStorage();
        this.items_.stream().filter(w -> w.weight != 0.0).forEach(w -> {
            TsDomain wdom = ((TsData)w.item).getDomain();
            TsDomain idom = wdom.intersection(dom);
            int wstart = idom.getStart().minus(wdom.getStart());
            int tstart = idom.getStart().minus(dom.getStart());
            int n = idom.getLength();
            new DataBlock(x, tstart, tstart + n, 1).addAY(w.weight, new DataBlock(((TsData)w.item).internalStorage(), wstart, wstart + n, 1));
        });
    }

    private TsData witem(int idx) {
        WeightedItem<TsData> item = this.items_.get(idx);
        if (item.weight == 1.0) {
            return (TsData)item.item;
        }
        return ((TsData)item.item).times(item.weight);
    }
}

