/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ucarima;

import ec.tstoolkit.BaseException;
import ec.tstoolkit.arima.ArimaModel;
import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.maths.polynomials.IRootSelector;
import ec.tstoolkit.ucarima.RootDecomposer;
import ec.tstoolkit.ucarima.SimpleModelDecomposer;
import ec.tstoolkit.ucarima.UcarimaModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ModelDecomposer {
    private final List<SimpleModelDecomposer> m_smds = new ArrayList<SimpleModelDecomposer>();

    public void add(IRootSelector selector) {
        RootDecomposer decomposer = new RootDecomposer(selector);
        this.m_smds.add(decomposer);
    }

    public void add(SimpleModelDecomposer smd) {
        this.m_smds.add(smd);
    }

    public void clear() {
        this.m_smds.clear();
    }

    public UcarimaModel decompose(IArimaModel m) {
        try {
            ArimaModel arima = ArimaModel.create(m);
            if (arima == null) {
                return null;
            }
            int n = this.m_smds.size();
            ArimaModel[] cmps = new ArimaModel[n + 1];
            if (n == 0) {
                cmps[0] = arima;
            } else {
                ArimaModel cur = arima;
                for (int i = 0; i < n; ++i) {
                    SimpleModelDecomposer smd = this.m_smds.get(i);
                    smd.setModel(cur);
                    cmps[i] = smd.getSignal();
                    cur = smd.getNoise();
                }
                cmps[n] = cur;
            }
            return new UcarimaModel(m, Arrays.asList(cmps));
        }
        catch (BaseException ex) {
            return null;
        }
    }
}

