/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Rule_Learning.PART;

import java.util.Vector;
import keel.Algorithms.Rule_Learning.PART.C45;
import keel.Algorithms.Rule_Learning.PART.Mask;
import keel.Algorithms.Rule_Learning.PART.MyDataset;
import keel.Algorithms.Rule_Learning.PART.Rule;
import keel.Algorithms.Rule_Learning.PART.Ruleset;
import keel.Algorithms.Rule_Learning.PART.SimpleRule;
import keel.Algorithms.Rule_Learning.PART.Tree;
import keel.Algorithms.Rule_Learning.PART.parseParameters;
import org.core.Fichero;

class PART {
    MyDataset train;
    MyDataset val;
    MyDataset test;
    String outputTr;
    String outputTst;
    String outputRules;
    private Vector classification_rules;
    private String default_class_name;
    private double CF;
    private int minItemsets;

    private Vector convert(Tree node, Rule base_rule, SimpleRule link_to_father, String type) {
        Rule node_rule = base_rule.getCopy();
        if (link_to_father != null) {
            node_rule.grow(link_to_father);
        }
        Vector<Rule> output = new Vector<Rule>();
        if (node != null && !node.isUnexplored) {
            if (node.isLeaf) {
                node_rule.setType(type);
                output.add(node_rule);
            } else {
                int cut_attribute = node.nodeModel.attributeIndex();
                for (int i = 0; i < node.getNChildren(); ++i) {
                    SimpleRule link_child = new SimpleRule();
                    link_child.setAttribute(cut_attribute);
                    if (this.train.getAttribute(cut_attribute).isDiscret()) {
                        link_child.setValue(i);
                        link_child.setOperator(SimpleRule.EQUAL);
                    } else {
                        link_child.setValue(node.nodeModel.getCutPoint());
                        if (i == 0) {
                            link_child.setOperator(SimpleRule.LOWER);
                        } else {
                            link_child.setOperator(SimpleRule.GREATER);
                        }
                    }
                    String child_type = "";
                    if (node.getChild(i) == null || node.isUnexplored) continue;
                    if (node.getChild((int)i).isLeaf) {
                        child_type = node.nodeModel.label(i, this.train);
                    }
                    Vector child_rules = this.convert(node.getChild(i), node_rule, link_child, child_type);
                    output.addAll(child_rules);
                }
            }
        }
        return output;
    }

    private void doOutput(MyDataset dataset, String filename, String[] classification) {
        String output = new String("");
        output = dataset.copyHeader();
        for (int i = 0; i < dataset.size(); ++i) {
            String class_name = dataset.getAttribute(dataset.classIndex).value((int)dataset.itemset(i).getClassValue());
            output = output + class_name + " " + classification[i] + "\n";
        }
        Fichero.escribeFichero(filename, output);
    }

    private void doRulesOutput(String filename, Ruleset[] rulesets) {
        String output = new String("");
        for (int i = 0; i < rulesets.length - 1; ++i) {
            output = output + "if(";
            for (int j = 0; j < rulesets[i].size(); ++j) {
                Rule current = rulesets[i].getRule(j);
                output = output + "(";
                for (int k = 0; k < current.size(); ++k) {
                    output = output + current.getSimpleRule(k);
                    if (k == current.size() - 1) continue;
                    output = output + " && ";
                }
                output = output + ")";
                if (j == rulesets[i].size() - 1) continue;
                output = output + " || ";
            }
            output = output + ")\n\t";
            output = output + "output=" + rulesets[i].getType() + "\nelse ";
        }
        output = output + "\n\toutput=" + rulesets[rulesets.length - 1].getType();
        Fichero.escribeFichero(filename, output);
    }

    private void doRulesOutput(String filename, Vector rules) {
        String output = new String("");
        output = output + "@Number of Rules: " + rules.size() + "\n";
        for (int i = 0; i < rules.size() - 1; ++i) {
            output = output + "if(";
            Rule current = (Rule)rules.elementAt(i);
            for (int k = 0; k < current.size(); ++k) {
                output = output + current.getSimpleRule(k);
                if (k == current.size() - 1) continue;
                output = output + " && ";
            }
            Mask class_filter = new Mask(this.train.size());
            this.train.filterByClass(class_filter, ((Rule)rules.elementAt(i)).getType());
            int covered = current.apply(this.train);
            int accuracy = current.apply(this.train, class_filter);
            output = output + ") (" + accuracy + "/" + covered + ")\n\t";
            output = output + "output=" + ((Rule)rules.elementAt(i)).getType() + "\nelse ";
        }
        output = output + "\n\toutput=" + ((Rule)rules.lastElement()).getType();
        Fichero.escribeFichero(filename, output);
    }

    public PART(parseParameters parameters) {
        String trainFileName = parameters.getTrainingInputFile();
        String valFileName = parameters.getValidationInputFile();
        String testFileName = parameters.getTestInputFile();
        System.out.println(trainFileName);
        System.out.println(valFileName);
        System.out.println(testFileName);
        this.train = new MyDataset(trainFileName, true);
        this.val = new MyDataset(valFileName, false);
        this.test = new MyDataset(testFileName, false);
        this.outputTr = parameters.getTrainingOutputFile();
        this.outputTst = parameters.getTestOutputFile();
        this.outputRules = parameters.getOutputFile(0);
        this.CF = Double.parseDouble(parameters.getParameter(0));
        this.minItemsets = Integer.parseInt(parameters.getParameter(1));
        if (this.CF < 0.0 || this.CF > 1.0) {
            this.CF = 0.25;
            System.err.println("Error: confidence must be in the interval [0,1]");
            System.err.println("Using default value: 0.25");
        }
        if (this.minItemsets <= 0) {
            this.minItemsets = 2;
            System.err.println("Error: itemsetPerLeaf must be greater than 0");
            System.err.println("Using default value: 2");
        }
        this.classification_rules = null;
        this.default_class_name = null;
    }

    public Vector treeToRules(Tree tree) {
        Vector output = null;
        output = !tree.isLeaf ? this.convert(tree, new Rule(), null, "") : new Vector();
        return output;
    }

    public void removeDuplicates(Vector rules) {
        for (int i = 0; i < rules.size(); ++i) {
            Rule current = (Rule)rules.elementAt(i);
            if (current.size() != 0) {
                for (int j = i + 1; j < rules.size(); ++j) {
                    if (!current.isEqual((Rule)rules.elementAt(j))) continue;
                    rules.remove(j);
                    --j;
                }
                continue;
            }
            rules.remove(i);
            --i;
        }
    }

    public void executeAlgorithm(MyDataset remained_data) throws Exception {
        this.classification_rules = new Vector();
        boolean end = false;
        while (remained_data.numItemsets() > 2 * this.minItemsets + 1 && !end) {
            int i;
            C45 subtree = null;
            subtree = new C45(remained_data, true, (float)this.CF, this.minItemsets);
            System.out.println("The partial tree\n" + subtree);
            Vector rules = this.treeToRules(subtree.getTree());
            System.out.println("The rules");
            for (int i2 = 0; i2 < rules.size(); ++i2) {
                System.out.println((Rule)rules.elementAt(i2));
            }
            int best_rule = -1;
            int best_value = -1;
            for (i = 0; i < rules.size(); ++i) {
                int curr_value = ((Rule)rules.elementAt(i)).apply(remained_data);
                if (curr_value <= best_value) continue;
                best_rule = i;
                best_value = curr_value;
            }
            if (best_rule > 0) {
                this.classification_rules.add((Rule)rules.elementAt(best_rule));
                MyDataset[] division = remained_data.split((Rule)rules.elementAt(best_rule));
                remained_data = division[1];
            } else {
                end = true;
            }
            System.out.println("The Final rules");
            for (i = 0; i < this.classification_rules.size(); ++i) {
                System.out.println((Rule)this.classification_rules.elementAt(i));
            }
        }
        this.default_class_name = remained_data.getMostFrequentClass();
        Rule default_rule = new Rule();
        default_rule.setType(this.default_class_name);
        this.classification_rules.add(default_rule);
    }

    public void execute() throws Exception {
        this.executeAlgorithm(this.train);
        String[] classification_train = this.train.classify(this.classification_rules);
        String[] classification_val = this.val.classify(this.classification_rules);
        String[] classification_test = this.test.classify(this.classification_rules);
        this.doOutput(this.val, this.outputTr, classification_val);
        this.doOutput(this.test, this.outputTst, classification_test);
        this.doRulesOutput(this.outputRules, this.classification_rules);
        System.out.println("Algorithm Finished");
    }
}

