/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.PNN;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.utilities.Distance;

public class MatrixOfDistances {
    protected PrototypeSet A;
    protected PrototypeSet B;
    protected PrototypeSet orphans;
    protected HashMap<Prototype, HashMap<Prototype, Double>> matrix;
    protected HashMap<Prototype, HashSet<Prototype>> invertedBList;

    double d(Prototype a, Prototype b) {
        return Distance.dSquared(a, b);
    }

    public MatrixOfDistances(PrototypeSet A, PrototypeSet B) {
        this.A = A;
        this.B = B;
        this.orphans = new PrototypeSet();
        this.matrix = new HashMap();
        this.invertedBList = new HashMap();
        for (Prototype b : B) {
            this.invertedBList.put(b, new HashSet());
        }
        for (Prototype a : A) {
            this.matrix.put(a, new HashMap());
            for (Prototype b : B) {
                if (a == b) continue;
                this.invertedBList.get(b).add(a);
                this.matrix.get(a).put(b, this.d(a, b));
            }
        }
    }

    public double get(Prototype a, Prototype b) {
        double dist = 0.0;
        dist = this.matrix.containsKey(a) ? this.matrix.get(a).get(b) : (this.matrix.containsKey(b) ? this.matrix.get(b).get(a) : -1.0);
        return dist;
    }

    public boolean removeFromA(Prototype a) {
        boolean present = this.matrix.containsKey(a);
        if (present) {
            this.matrix.remove(a);
        }
        return present;
    }

    public boolean removeFromB(Prototype x) {
        int _size = this.B.size();
        boolean found = false;
        Prototype Bi = null;
        for (int i = 0; i < _size && !found; ++i) {
            Bi = (Prototype)this.B.get(i);
            found = x == Bi;
        }
        if (found) {
            ArrayList list = new ArrayList(this.invertedBList.get(Bi));
            for (Prototype p : list) {
                this.matrix.get(p).remove(x);
            }
        }
        return found;
    }

    public boolean remove(Prototype x) {
        if (this.matrix.containsKey(x)) {
            return this.removeFromA(x);
        }
        return this.removeFromB(x);
    }

    public void add(Prototype x) {
        this.orphans.add(x);
        HashMap<Prototype, Double> xRow = new HashMap<Prototype, Double>();
        this.matrix.put(x, xRow);
        for (Prototype a : this.A) {
            if (x == a) continue;
            xRow.put(a, Distance.d(x, a));
        }
        for (Prototype b : this.B) {
            if (x == b || xRow.containsKey(b)) continue;
            xRow.put(b, this.d(x, b));
        }
    }

    public void addToA(Prototype x) {
        HashMap<Prototype, Double> xRow = new HashMap<Prototype, Double>();
        this.matrix.put(x, xRow);
        for (Prototype b : this.B) {
            if (x == b || xRow.containsKey(b)) continue;
            xRow.put(b, this.d(x, b));
        }
    }

    public void addToB(Prototype x) {
        this.invertedBList.put(x, new HashSet());
        HashMap<Prototype, Double> xRow = new HashMap<Prototype, Double>();
        this.matrix.put(x, xRow);
        for (Prototype a : this.A) {
            if (x == a || xRow.containsKey(a)) continue;
            xRow.put(a, this.d(x, a));
            this.invertedBList.get(x).add(a);
        }
    }
}

