/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.extract.test;

import cc.mallet.extract.CRFExtractor;
import cc.mallet.extract.DocumentViewer;
import cc.mallet.extract.Extraction;
import cc.mallet.extract.test.TestLatticeViewer;
import cc.mallet.fst.CRF;
import cc.mallet.fst.CRFTrainerByLabelLikelihood;
import cc.mallet.fst.tests.TestCRF;
import cc.mallet.fst.tests.TestMEMM;
import cc.mallet.pipe.Pipe;
import cc.mallet.pipe.iterator.ArrayIterator;
import cc.mallet.types.InstanceList;
import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestDocumentViewer
extends TestCase {
    private File outputDir = new File("extract");

    public TestDocumentViewer(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(TestDocumentViewer.class);
    }

    public void testSpaceViewer() throws IOException {
        Pipe pipe = TestMEMM.makeSpacePredictionPipe();
        Object[] data0 = new String[]{TestCRF.data[0]};
        Object[] data1 = new String[]{TestCRF.data[1]};
        InstanceList training = new InstanceList(pipe);
        training.addThruPipe(new ArrayIterator(data0));
        InstanceList testing = new InstanceList(pipe);
        testing.addThruPipe(new ArrayIterator(data1));
        CRF crf = new CRF(pipe, null);
        crf.addFullyConnectedStatesForLabels();
        CRFTrainerByLabelLikelihood crft = new CRFTrainerByLabelLikelihood(crf);
        crft.trainIncremental(training);
        CRFExtractor extor = TestLatticeViewer.hackCrfExtor(crf);
        Extraction extraction = extor.extract(new ArrayIterator(data1));
        if (!this.outputDir.exists()) {
            this.outputDir.mkdir();
        }
        DocumentViewer.writeExtraction(this.outputDir, extraction);
    }

    public static void main(String[] args) throws Throwable {
        TestSuite theSuite;
        if (args.length > 0) {
            theSuite = new TestSuite();
            for (int i = 0; i < args.length; ++i) {
                theSuite.addTest((Test)new TestDocumentViewer(args[i]));
            }
        } else {
            theSuite = (TestSuite)TestDocumentViewer.suite();
        }
        TestRunner.run((Test)theSuite);
    }
}

