/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.imageioimpl;

import com.sun.media.jai.imageioimpl.I18N;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.ImageLayout;
import javax.media.jai.OpImage;

final class ImageReadOpImage
extends OpImage {
    private ImageReadParam param;
    private ImageReader reader;
    private int imageIndex;
    private boolean readThumbnails;
    private boolean streamMetadataRead = false;
    private boolean imageMetadataRead = false;
    private ImageInputStream streamToClose;
    private int scaleX;
    private int scaleY;
    private int transX;
    private int transY;

    private static ImageLayout layoutHelper(ImageLayout il, ImageReadParam param, ImageReader reader, int imageIndex) throws IOException {
        ImageLayout layout;
        ImageLayout imageLayout = layout = il == null ? new ImageLayout() : (ImageLayout)il.clone();
        if (!layout.isValid(256) && !layout.isValid(512)) {
            ImageTypeSpecifier imageType;
            ImageTypeSpecifier imageTypeSpecifier = imageType = param != null && param.getDestinationType() != null ? param.getDestinationType() : reader.getRawImageType(imageIndex);
            if (imageType == null) {
                Iterator<ImageTypeSpecifier> imageTypes = reader.getImageTypes(imageIndex);
                while (imageType == null && imageTypes.hasNext()) {
                    imageType = imageTypes.next();
                }
            }
            if (imageType != null) {
                layout.setSampleModel(imageType.getSampleModel());
                layout.setColorModel(imageType.getColorModel());
            }
        }
        Dimension sourceSize = ImageReadOpImage.getSourceSize(param, reader, imageIndex);
        Rectangle srcRegion = new Rectangle();
        Rectangle destRegion = new Rectangle();
        ImageReadOpImage.computeRegions(param, sourceSize.width, sourceSize.height, layout.getMinX(null), layout.getMinY(null), false, srcRegion, destRegion);
        if (!destRegion.isEmpty()) {
            Rectangle destBounds;
            if (!layout.isValid(4)) {
                layout.setWidth(destRegion.width);
            }
            if (!layout.isValid(8)) {
                layout.setHeight(destRegion.height);
            }
            if (!layout.isValid(1)) {
                layout.setMinX(destRegion.x);
            }
            if (!layout.isValid(2)) {
                layout.setMinY(destRegion.y);
            }
            if (destRegion.intersection(destBounds = new Rectangle(layout.getMinX(null), layout.getMinY(null), layout.getWidth(null), layout.getHeight(null))).isEmpty()) {
                throw new IllegalArgumentException(I18N.getString("ImageReadOpImage0"));
            }
        }
        if (!layout.isValid(16)) {
            layout.setTileGridXOffset(reader.getTileGridXOffset(imageIndex));
        }
        if (!layout.isValid(32)) {
            layout.setTileGridYOffset(reader.getTileGridYOffset(imageIndex));
        }
        if (!layout.isValid(64)) {
            layout.setTileWidth(reader.getTileWidth(imageIndex));
        }
        if (!layout.isValid(128)) {
            layout.setTileHeight(reader.getTileHeight(imageIndex));
        }
        return layout;
    }

    private static boolean isCompatibleType(ImageTypeSpecifier imageType, ImageReader reader, int imageIndex) throws IOException {
        Iterator<ImageTypeSpecifier> imageTypes = reader.getImageTypes(imageIndex);
        boolean foundIt = false;
        while (imageTypes.hasNext()) {
            ImageTypeSpecifier type = imageTypes.next();
            if (!type.equals(imageType)) continue;
            foundIt = true;
            break;
        }
        return foundIt;
    }

    private static Dimension getSourceSize(ImageReadParam param, ImageReader reader, int imageIndex) throws IOException {
        Dimension sourceSize = null;
        if (param != null && param.canSetSourceRenderSize()) {
            sourceSize = param.getSourceRenderSize();
        }
        if (sourceSize == null) {
            sourceSize = new Dimension(reader.getWidth(imageIndex), reader.getHeight(imageIndex));
        }
        return sourceSize;
    }

    private static Rectangle getSourceRegion(ImageReadParam param, int srcWidth, int srcHeight) {
        Rectangle sourceRegion = new Rectangle(0, 0, srcWidth, srcHeight);
        if (param != null) {
            Rectangle region = param.getSourceRegion();
            if (region != null) {
                sourceRegion = sourceRegion.intersection(region);
            }
            int subsampleXOffset = param.getSubsamplingXOffset();
            int subsampleYOffset = param.getSubsamplingYOffset();
            sourceRegion.x += subsampleXOffset;
            sourceRegion.y += subsampleYOffset;
            sourceRegion.width -= subsampleXOffset;
            sourceRegion.height -= subsampleYOffset;
        }
        return sourceRegion;
    }

    private static void computeRegions(ImageReadParam param, int srcWidth, int srcHeight, int destMinX, int destMinY, boolean clipDestRegion, Rectangle srcRegion, Rectangle destRegion) {
        if (srcRegion == null) {
            throw new IllegalArgumentException("srcRegion == null");
        }
        if (destRegion == null) {
            throw new IllegalArgumentException("destRegion == null");
        }
        srcRegion.setBounds(0, 0, srcWidth, srcHeight);
        destRegion.setBounds(destMinX, destMinY, srcWidth, srcHeight);
        int periodX = 1;
        int periodY = 1;
        int gridX = 0;
        int gridY = 0;
        if (param != null) {
            Rectangle paramSrcRegion = param.getSourceRegion();
            if (paramSrcRegion != null) {
                srcRegion.setBounds(srcRegion.intersection(paramSrcRegion));
            }
            periodX = param.getSourceXSubsampling();
            periodY = param.getSourceYSubsampling();
            gridX = param.getSubsamplingXOffset();
            gridY = param.getSubsamplingYOffset();
            srcRegion.translate(gridX, gridY);
            srcRegion.width -= gridX;
            srcRegion.height -= gridY;
            Point destinationOffset = param.getDestinationOffset();
            destRegion.translate(destinationOffset.x, destinationOffset.y);
        }
        if (clipDestRegion) {
            if (destRegion.x < 0) {
                int delta = -destRegion.x * periodX;
                srcRegion.x += delta;
                srcRegion.width -= delta;
                destRegion.x = 0;
            }
            if (destRegion.y < 0) {
                int delta = -destRegion.y * periodY;
                srcRegion.y += delta;
                srcRegion.height -= delta;
                destRegion.y = 0;
            }
        }
        int subsampledWidth = (srcRegion.width + periodX - 1) / periodX;
        int subsampledHeight = (srcRegion.height + periodY - 1) / periodY;
        destRegion.width = subsampledWidth;
        destRegion.height = subsampledHeight;
        if (srcRegion.isEmpty() || destRegion.isEmpty()) {
            throw new IllegalArgumentException(I18N.getString("ImageReadOpImage1"));
        }
    }

    ImageReadOpImage(ImageLayout layout, Map configuration, ImageReadParam param, ImageReader reader, int imageIndex, boolean readThumbnails, ImageInputStream streamToClose) throws IOException {
        super(null, ImageReadOpImage.layoutHelper(layout, param, reader, imageIndex), configuration, false);
        ImageTypeSpecifier newImageType;
        if (param == null) {
            param = reader.getDefaultReadParam();
        } else if (param instanceof Cloneable) {
            this.param = param;
        } else if (param.getClass().getName().equals("javax.imageio.ImageReadParam")) {
            ImageReadParam newParam = new ImageReadParam();
            if (param.hasController()) {
                newParam.setController(param.getController());
            }
            newParam.setDestination(param.getDestination());
            if (param.getDestinationType() != null) {
                newParam.setDestinationType(param.getDestinationType());
            }
            newParam.setDestinationBands(param.getDestinationBands());
            newParam.setDestinationOffset(param.getDestinationOffset());
            newParam.setSourceBands(param.getSourceBands());
            newParam.setSourceRegion(param.getSourceRegion());
            if (param.getSourceMaxProgressivePass() != Integer.MAX_VALUE) {
                newParam.setSourceProgressivePasses(param.getSourceMinProgressivePass(), param.getSourceNumProgressivePasses());
            }
            if (param.canSetSourceRenderSize()) {
                newParam.setSourceRenderSize(param.getSourceRenderSize());
            }
            newParam.setSourceSubsampling(param.getSourceXSubsampling(), param.getSourceYSubsampling(), param.getSubsamplingXOffset(), param.getSubsamplingYOffset());
            param = newParam;
        }
        if (readThumbnails && !reader.hasThumbnails(imageIndex)) {
            readThumbnails = false;
        }
        this.param = param;
        this.reader = reader;
        this.imageIndex = imageIndex;
        this.readThumbnails = readThumbnails;
        this.streamToClose = streamToClose;
        if (param.getDestinationType() != null && !ImageReadOpImage.isCompatibleType(param.getDestinationType(), reader, imageIndex) && this.sampleModel != null && this.colorModel != null && ImageReadOpImage.isCompatibleType(newImageType = new ImageTypeSpecifier(this.colorModel, this.sampleModel), reader, imageIndex)) {
            param.setDestinationType(newImageType);
        }
        Dimension sourceSize = ImageReadOpImage.getSourceSize(param, reader, imageIndex);
        Rectangle srcRegion = ImageReadOpImage.getSourceRegion(param, sourceSize.width, sourceSize.height);
        Point destinationOffset = this.param.getDestinationOffset();
        this.scaleX = this.param.getSourceXSubsampling();
        this.scaleY = this.param.getSourceYSubsampling();
        this.transX = srcRegion.x + this.param.getSubsamplingXOffset() - this.param.getSourceXSubsampling() * (this.minX + destinationOffset.x);
        this.transY = srcRegion.y + this.param.getSubsamplingYOffset() - this.param.getSourceYSubsampling() * (this.minY + destinationOffset.y);
        this.param.setDestinationOffset(new Point());
        this.setProperty("JAI.ImageReadParam", param);
        this.setProperty("JAI.ImageReader", reader);
        if (!reader.isIgnoringMetadata()) {
            ImageReaderSpi provider = reader.getOriginatingProvider();
            if (provider == null || provider.isStandardStreamMetadataFormatSupported() || provider.getNativeStreamMetadataFormatName() != null) {
                this.setProperty("JAI.StreamMetadata", Image.UndefinedProperty);
            } else {
                this.streamMetadataRead = true;
            }
            if (provider == null || provider.isStandardImageMetadataFormatSupported() || provider.getNativeImageMetadataFormatName() != null) {
                this.setProperty("JAI.ImageMetadata", Image.UndefinedProperty);
            } else {
                this.imageMetadataRead = true;
            }
        }
        if (readThumbnails && reader.readerSupportsThumbnails()) {
            this.setProperty("JAI.Thumbnails", Image.UndefinedProperty);
        }
    }

    public boolean computesUniqueTiles() {
        return false;
    }

    private Rectangle computeSourceRect(Rectangle destRect) {
        Rectangle sourceRect = new Rectangle();
        sourceRect.x = this.scaleX * destRect.x + this.transX;
        sourceRect.y = this.scaleY * destRect.y + this.transY;
        sourceRect.width = this.scaleX * (destRect.x + destRect.width) + this.transX - sourceRect.x;
        sourceRect.height = this.scaleY * (destRect.y + destRect.height) + this.transY - sourceRect.y;
        return sourceRect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Raster computeTile(int tileX, int tileY) {
        Point org = new Point(this.tileXToX(tileX), this.tileYToY(tileY));
        Rectangle rect = new Rectangle(org.x, org.y, this.tileWidth, this.tileHeight);
        Rectangle destRect = rect.intersection(this.getBounds());
        Rectangle srcRect = this.computeSourceRect(destRect);
        WritableRaster readerTile = null;
        try {
            ImageReader imageReader = this.reader;
            synchronized (imageReader) {
                this.param.setSourceRegion(srcRect);
                BufferedImage bi = this.reader.read(this.imageIndex, this.param);
                WritableRaster ras = bi.getRaster();
                readerTile = ras.createWritableChild(0, 0, ras.getWidth(), ras.getHeight(), org.x, org.y, null);
            }
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        WritableRaster tile = null;
        if (this.sampleModel == readerTile.getSampleModel()) {
            tile = readerTile;
        } else {
            tile = Raster.createWritableRaster(this.sampleModel, org);
            tile.setRect(readerTile);
        }
        return tile;
    }

    public Rectangle mapSourceRect(Rectangle sourceRect, int sourceIndex) {
        throw new IllegalArgumentException(I18N.getString("ImageReadOpImage2"));
    }

    public Rectangle mapDestRect(Rectangle destRect, int sourceIndex) {
        throw new IllegalArgumentException(I18N.getString("ImageReadOpImage2"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String name) {
        Object property = super.getProperty(name);
        if (property == null || property == Image.UndefinedProperty) {
            if (this.readThumbnails && name.equalsIgnoreCase("JAI.Thumbnails")) {
                ImageReader imageReader = this.reader;
                synchronized (imageReader) {
                    if (this.readThumbnails) {
                        try {
                            block29: {
                                try {
                                    int numThumbnails = this.reader.getNumThumbnails(this.imageIndex);
                                    if (numThumbnails <= 0) break block29;
                                    BufferedImage[] thumbnails = new BufferedImage[numThumbnails];
                                    for (int i = 0; i < numThumbnails; ++i) {
                                        thumbnails[i] = this.reader.readThumbnail(this.imageIndex, i);
                                    }
                                    this.setProperty("JAI.Thumbnails", thumbnails);
                                    property = thumbnails;
                                }
                                catch (IOException e2) {
                                    throw new RuntimeException(e2);
                                }
                            }
                            Object var8_12 = null;
                            if (property == null) {
                                property = Image.UndefinedProperty;
                            }
                            this.readThumbnails = false;
                        }
                        catch (Throwable throwable) {
                            Object var8_13 = null;
                            if (property == null) {
                                property = Image.UndefinedProperty;
                            }
                            this.readThumbnails = false;
                            throw throwable;
                        }
                    }
                }
            }
            if (!this.reader.isIgnoringMetadata() && (!this.streamMetadataRead && name.equalsIgnoreCase("JAI.StreamMetadata") || !this.imageMetadataRead && name.equalsIgnoreCase("JAI.ImageMetadata"))) {
                ImageReader imageReader = this.reader;
                synchronized (imageReader) {
                    boolean isStreamMetadata = name.equalsIgnoreCase("JAI.StreamMetadata");
                    if (!(!isStreamMetadata ? this.imageMetadataRead : this.streamMetadataRead)) {
                        String propertyName = isStreamMetadata ? "JAI.StreamMetadata" : "JAI.ImageMetadata";
                        IIOMetadata metadata = null;
                        try {
                            try {
                                IIOMetadata iIOMetadata = metadata = isStreamMetadata ? this.reader.getStreamMetadata() : this.reader.getImageMetadata(this.imageIndex);
                                if (metadata != null) {
                                    this.setProperty(propertyName, metadata);
                                }
                                property = metadata;
                            }
                            catch (IOException e3) {
                                throw new RuntimeException(e3);
                            }
                            Object var11_17 = null;
                            if (property == null) {
                                property = Image.UndefinedProperty;
                            }
                            if (isStreamMetadata) {
                                this.streamMetadataRead = true;
                            } else {
                                this.imageMetadataRead = true;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var11_18 = null;
                            if (property == null) {
                                property = Image.UndefinedProperty;
                            }
                            if (isStreamMetadata) {
                                this.streamMetadataRead = true;
                            } else {
                                this.imageMetadataRead = true;
                            }
                            throw throwable;
                        }
                    }
                }
            }
        }
        return property;
    }

    public void dispose() {
        if (this.streamToClose != null) {
            try {
                this.streamToClose.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.dispose();
    }
}

