/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ColormapOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class InvertOpImage
extends ColormapOpImage {
    public InvertOpImage(RenderedImage source, Map config, ImageLayout layout) {
        super(source, layout, config, true);
        this.permitInPlaceOperation();
        this.initializeColormapOperation();
    }

    protected void transformColormap(byte[][] colormap) {
        for (int b2 = 0; b2 < 3; ++b2) {
            byte[] map = colormap[b2];
            int mapSize = map.length;
            for (int i = 0; i < mapSize; ++i) {
                map[i] = (byte)(255 - (map[i] & 0xFF));
            }
        }
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        RasterAccessor s2 = new RasterAccessor(sources[0], destRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor d2 = new RasterAccessor(dest, destRect, formatTags[1], this.getColorModel());
        if (d2.isBinary()) {
            byte[] srcBits = s2.getBinaryDataArray();
            byte[] dstBits = d2.getBinaryDataArray();
            int length = dstBits.length;
            for (int i = 0; i < length; ++i) {
                dstBits[i] = ~srcBits[i];
            }
            d2.copyBinaryDataToRaster();
        } else {
            switch (d2.getDataType()) {
                case 0: {
                    this.computeRectByte(s2, d2);
                    break;
                }
                case 1: {
                    this.computeRectUShort(s2, d2);
                    break;
                }
                case 2: {
                    this.computeRectShort(s2, d2);
                    break;
                }
                case 3: {
                    this.computeRectInt(s2, d2);
                    break;
                }
                case 4: 
                case 5: {
                    throw new RuntimeException(JaiI18N.getString("InvertOpImage0"));
                }
            }
            d2.copyDataToRaster();
        }
    }

    private void computeRectByte(RasterAccessor src, RasterAccessor dst) {
        int sLineStride = src.getScanlineStride();
        int sPixelStride = src.getPixelStride();
        int[] sBandOffsets = src.getBandOffsets();
        byte[][] sData = src.getByteDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        byte[][] dData = dst.getByteDataArrays();
        for (int b2 = 0; b2 < bands; ++b2) {
            byte[] s2 = sData[b2];
            byte[] d2 = dData[b2];
            int sLineOffset = sBandOffsets[b2];
            int dLineOffset = dBandOffsets[b2];
            for (int h2 = 0; h2 < dheight; ++h2) {
                int sPixelOffset = sLineOffset;
                int dPixelOffset = dLineOffset;
                sLineOffset += sLineStride;
                dLineOffset += dLineStride;
                int dstEnd = dPixelOffset + dwidth * dPixelStride;
                while (dPixelOffset < dstEnd) {
                    d2[dPixelOffset] = (byte)(255 - (s2[sPixelOffset] & 0xFF));
                    sPixelOffset += sPixelStride;
                    dPixelOffset += dPixelStride;
                }
            }
        }
    }

    private void computeRectUShort(RasterAccessor src, RasterAccessor dst) {
        int sLineStride = src.getScanlineStride();
        int sPixelStride = src.getPixelStride();
        int[] sBandOffsets = src.getBandOffsets();
        short[][] sData = src.getShortDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        short[][] dData = dst.getShortDataArrays();
        for (int b2 = 0; b2 < bands; ++b2) {
            short[] s2 = sData[b2];
            short[] d2 = dData[b2];
            int sLineOffset = sBandOffsets[b2];
            int dLineOffset = dBandOffsets[b2];
            for (int h2 = 0; h2 < dheight; ++h2) {
                int sPixelOffset = sLineOffset;
                int dPixelOffset = dLineOffset;
                sLineOffset += sLineStride;
                dLineOffset += dLineStride;
                int dstEnd = dPixelOffset + dwidth * dPixelStride;
                while (dPixelOffset < dstEnd) {
                    d2[dPixelOffset] = (short)(65535 - (s2[sPixelOffset] & 0xFFFF));
                    sPixelOffset += sPixelStride;
                    dPixelOffset += dPixelStride;
                }
            }
        }
    }

    private void computeRectShort(RasterAccessor src, RasterAccessor dst) {
        int sLineStride = src.getScanlineStride();
        int sPixelStride = src.getPixelStride();
        int[] sBandOffsets = src.getBandOffsets();
        short[][] sData = src.getShortDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        short[][] dData = dst.getShortDataArrays();
        for (int b2 = 0; b2 < bands; ++b2) {
            short[] s2 = sData[b2];
            short[] d2 = dData[b2];
            int sLineOffset = sBandOffsets[b2];
            int dLineOffset = dBandOffsets[b2];
            for (int h2 = 0; h2 < dheight; ++h2) {
                int sPixelOffset = sLineOffset;
                int dPixelOffset = dLineOffset;
                sLineOffset += sLineStride;
                dLineOffset += dLineStride;
                int dstEnd = dPixelOffset + dwidth * dPixelStride;
                while (dPixelOffset < dstEnd) {
                    d2[dPixelOffset] = (short)(Short.MAX_VALUE - s2[sPixelOffset]);
                    sPixelOffset += sPixelStride;
                    dPixelOffset += dPixelStride;
                }
            }
        }
    }

    private void computeRectInt(RasterAccessor src, RasterAccessor dst) {
        int sLineStride = src.getScanlineStride();
        int sPixelStride = src.getPixelStride();
        int[] sBandOffsets = src.getBandOffsets();
        int[][] sData = src.getIntDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        int[][] dData = dst.getIntDataArrays();
        int[] s2 = sData[0];
        int[] d2 = dData[0];
        int pixels = d2.length;
        switch (this.sampleModel.getTransferType()) {
            case 0: {
                for (int i = 0; i < pixels; ++i) {
                    d2[i] = ~s2[i] & 0xFF;
                }
                break;
            }
            case 1: {
                for (int i = 0; i < pixels; ++i) {
                    d2[i] = ~s2[i] & 0xFFFF;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < pixels; ++i) {
                    d2[i] = Short.MAX_VALUE - s2[i];
                }
                break;
            }
            case 3: {
                for (int b2 = 0; b2 < bands; ++b2) {
                    s2 = sData[b2];
                    d2 = dData[b2];
                    int sLineOffset = sBandOffsets[b2];
                    int dLineOffset = dBandOffsets[b2];
                    for (int h2 = 0; h2 < dheight; ++h2) {
                        int sPixelOffset = sLineOffset;
                        int dPixelOffset = dLineOffset;
                        sLineOffset += sLineStride;
                        dLineOffset += dLineStride;
                        int dstEnd = dPixelOffset + dwidth * dPixelStride;
                        while (dPixelOffset < dstEnd) {
                            d2[dPixelOffset] = Integer.MAX_VALUE - s2[sPixelOffset];
                            sPixelOffset += sPixelStride;
                            dPixelOffset += dPixelStride;
                        }
                    }
                }
                break;
            }
        }
    }
}

