/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ColormapOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class ThresholdOpImage
extends ColormapOpImage {
    private double[] low;
    private double[] high;
    private double[] constants;
    private byte[][] byteTable = null;

    public ThresholdOpImage(RenderedImage source, Map config, ImageLayout layout, double[] low, double[] high, double[] constants) {
        super(source, layout, config, true);
        int numBands = this.getSampleModel().getNumBands();
        this.low = new double[numBands];
        this.high = new double[numBands];
        this.constants = new double[numBands];
        for (int i = 0; i < numBands; ++i) {
            this.low[i] = low.length < numBands ? low[0] : low[i];
            this.high[i] = high.length < numBands ? high[0] : high[i];
            this.constants[i] = constants.length < numBands ? constants[0] : constants[i];
        }
        this.permitInPlaceOperation();
        this.initializeColormapOperation();
    }

    protected void transformColormap(byte[][] colormap) {
        this.initByteTable();
        for (int b2 = 0; b2 < 3; ++b2) {
            byte[] map = colormap[b2];
            byte[] luTable = this.byteTable[b2 >= this.byteTable.length ? 0 : b2];
            int mapSize = map.length;
            for (int i = 0; i < mapSize; ++i) {
                map[i] = luTable[map[i] & 0xFF];
            }
        }
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        RasterAccessor src = new RasterAccessor(sources[0], srcRect, formatTags[0], this.getSource(0).getColorModel());
        RasterAccessor dst = new RasterAccessor(dest, destRect, formatTags[1], this.getColorModel());
        int srcPixelStride = src.getPixelStride();
        int srcLineStride = src.getScanlineStride();
        int[] srcBandOffsets = src.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstLineStride = dst.getScanlineStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        int width = dst.getWidth() * dstPixelStride;
        int height = dst.getHeight() * dstLineStride;
        int bands = dst.getNumBands();
        switch (dst.getDataType()) {
            case 0: {
                this.byteLoop(width, height, bands, srcPixelStride, srcLineStride, srcBandOffsets, src.getByteDataArrays(), dstPixelStride, dstLineStride, dstBandOffsets, dst.getByteDataArrays());
                break;
            }
            case 2: {
                this.shortLoop(width, height, bands, srcPixelStride, srcLineStride, srcBandOffsets, src.getShortDataArrays(), dstPixelStride, dstLineStride, dstBandOffsets, dst.getShortDataArrays());
                break;
            }
            case 1: {
                this.ushortLoop(width, height, bands, srcPixelStride, srcLineStride, srcBandOffsets, src.getShortDataArrays(), dstPixelStride, dstLineStride, dstBandOffsets, dst.getShortDataArrays());
                break;
            }
            case 3: {
                this.intLoop(width, height, bands, srcPixelStride, srcLineStride, srcBandOffsets, src.getIntDataArrays(), dstPixelStride, dstLineStride, dstBandOffsets, dst.getIntDataArrays());
                break;
            }
            case 4: {
                this.floatLoop(width, height, bands, srcPixelStride, srcLineStride, srcBandOffsets, src.getFloatDataArrays(), dstPixelStride, dstLineStride, dstBandOffsets, dst.getFloatDataArrays());
                break;
            }
            case 5: {
                this.doubleLoop(width, height, bands, srcPixelStride, srcLineStride, srcBandOffsets, src.getDoubleDataArrays(), dstPixelStride, dstLineStride, dstBandOffsets, dst.getDoubleDataArrays());
            }
        }
        if (dst.isDataCopy()) {
            dst.clampDataArrays();
            dst.copyDataToRaster();
        }
    }

    private void byteLoop(int width, int height, int bands, int srcPixelStride, int srcLineStride, int[] srcBandOffsets, byte[][] srcData, int dstPixelStride, int dstLineStride, int[] dstBandOffsets, byte[][] dstData) {
        this.initByteTable();
        for (int b2 = 0; b2 < bands; ++b2) {
            byte[] s2 = srcData[b2];
            byte[] d2 = dstData[b2];
            byte[] t = this.byteTable[b2];
            int heightEnd = dstBandOffsets[b2] + height;
            int dstLineOffset = dstBandOffsets[b2];
            int srcLineOffset = srcBandOffsets[b2];
            while (dstLineOffset < heightEnd) {
                int widthEnd = dstLineOffset + width;
                int dstPixelOffset = dstLineOffset;
                int srcPixelOffset = srcLineOffset;
                while (dstPixelOffset < widthEnd) {
                    d2[dstPixelOffset] = t[s2[srcPixelOffset] & 0xFF];
                    dstPixelOffset += dstPixelStride;
                    srcPixelOffset += srcPixelStride;
                }
                dstLineOffset += dstLineStride;
                srcLineOffset += srcLineStride;
            }
        }
    }

    private void shortLoop(int width, int height, int bands, int srcPixelStride, int srcLineStride, int[] srcBandOffsets, short[][] srcData, int dstPixelStride, int dstLineStride, int[] dstBandOffsets, short[][] dstData) {
        for (int b2 = 0; b2 < bands; ++b2) {
            short[] s2 = srcData[b2];
            short[] d2 = dstData[b2];
            double l = this.low[b2];
            double h2 = this.high[b2];
            short c2 = (short)this.constants[b2];
            int heightEnd = dstBandOffsets[b2] + height;
            int dstLineOffset = dstBandOffsets[b2];
            int srcLineOffset = srcBandOffsets[b2];
            while (dstLineOffset < heightEnd) {
                int widthEnd = dstLineOffset + width;
                int dstPixelOffset = dstLineOffset;
                int srcPixelOffset = srcLineOffset;
                while (dstPixelOffset < widthEnd) {
                    short p = s2[srcPixelOffset];
                    d2[dstPixelOffset] = (double)p >= l && (double)p <= h2 ? c2 : p;
                    dstPixelOffset += dstPixelStride;
                    srcPixelOffset += srcPixelStride;
                }
                dstLineOffset += dstLineStride;
                srcLineOffset += srcLineStride;
            }
        }
    }

    private void ushortLoop(int width, int height, int bands, int srcPixelStride, int srcLineStride, int[] srcBandOffsets, short[][] srcData, int dstPixelStride, int dstLineStride, int[] dstBandOffsets, short[][] dstData) {
        for (int b2 = 0; b2 < bands; ++b2) {
            short[] s2 = srcData[b2];
            short[] d2 = dstData[b2];
            double l = this.low[b2];
            double h2 = this.high[b2];
            short c2 = (short)this.constants[b2];
            int heightEnd = dstBandOffsets[b2] + height;
            int dstLineOffset = dstBandOffsets[b2];
            int srcLineOffset = srcBandOffsets[b2];
            while (dstLineOffset < heightEnd) {
                int widthEnd = dstLineOffset + width;
                int dstPixelOffset = dstLineOffset;
                int srcPixelOffset = srcLineOffset;
                while (dstPixelOffset < widthEnd) {
                    int p = s2[srcPixelOffset] & 0xFFFF;
                    d2[dstPixelOffset] = (double)p >= l && (double)p <= h2 ? c2 : (short)p;
                    dstPixelOffset += dstPixelStride;
                    srcPixelOffset += srcPixelStride;
                }
                dstLineOffset += dstLineStride;
                srcLineOffset += srcLineStride;
            }
        }
    }

    private void intLoop(int width, int height, int bands, int srcPixelStride, int srcLineStride, int[] srcBandOffsets, int[][] srcData, int dstPixelStride, int dstLineStride, int[] dstBandOffsets, int[][] dstData) {
        for (int b2 = 0; b2 < bands; ++b2) {
            int[] s2 = srcData[b2];
            int[] d2 = dstData[b2];
            double l = this.low[b2];
            double h2 = this.high[b2];
            int c2 = (int)this.constants[b2];
            int heightEnd = dstBandOffsets[b2] + height;
            int dstLineOffset = dstBandOffsets[b2];
            int srcLineOffset = srcBandOffsets[b2];
            while (dstLineOffset < heightEnd) {
                int widthEnd = dstLineOffset + width;
                int dstPixelOffset = dstLineOffset;
                int srcPixelOffset = srcLineOffset;
                while (dstPixelOffset < widthEnd) {
                    int p = s2[srcPixelOffset];
                    d2[dstPixelOffset] = (double)p >= l && (double)p <= h2 ? c2 : p;
                    dstPixelOffset += dstPixelStride;
                    srcPixelOffset += srcPixelStride;
                }
                dstLineOffset += dstLineStride;
                srcLineOffset += srcLineStride;
            }
        }
    }

    private void floatLoop(int width, int height, int bands, int srcPixelStride, int srcLineStride, int[] srcBandOffsets, float[][] srcData, int dstPixelStride, int dstLineStride, int[] dstBandOffsets, float[][] dstData) {
        for (int b2 = 0; b2 < bands; ++b2) {
            float[] s2 = srcData[b2];
            float[] d2 = dstData[b2];
            double l = this.low[b2];
            double h2 = this.high[b2];
            float c2 = (float)this.constants[b2];
            int heightEnd = dstBandOffsets[b2] + height;
            int dstLineOffset = dstBandOffsets[b2];
            int srcLineOffset = srcBandOffsets[b2];
            while (dstLineOffset < heightEnd) {
                int widthEnd = dstLineOffset + width;
                int dstPixelOffset = dstLineOffset;
                int srcPixelOffset = srcLineOffset;
                while (dstPixelOffset < widthEnd) {
                    float p = s2[srcPixelOffset];
                    d2[dstPixelOffset] = (double)p >= l && (double)p <= h2 ? c2 : p;
                    dstPixelOffset += dstPixelStride;
                    srcPixelOffset += srcPixelStride;
                }
                dstLineOffset += dstLineStride;
                srcLineOffset += srcLineStride;
            }
        }
    }

    private void doubleLoop(int width, int height, int bands, int srcPixelStride, int srcLineStride, int[] srcBandOffsets, double[][] srcData, int dstPixelStride, int dstLineStride, int[] dstBandOffsets, double[][] dstData) {
        for (int b2 = 0; b2 < bands; ++b2) {
            double[] s2 = srcData[b2];
            double[] d2 = dstData[b2];
            double l = this.low[b2];
            double h2 = this.high[b2];
            double c2 = this.constants[b2];
            int heightEnd = dstBandOffsets[b2] + height;
            int dstLineOffset = dstBandOffsets[b2];
            int srcLineOffset = srcBandOffsets[b2];
            while (dstLineOffset < heightEnd) {
                int widthEnd = dstLineOffset + width;
                int dstPixelOffset = dstLineOffset;
                int srcPixelOffset = srcLineOffset;
                while (dstPixelOffset < widthEnd) {
                    double p = s2[srcPixelOffset];
                    d2[dstPixelOffset] = p >= l && p <= h2 ? c2 : p;
                    dstPixelOffset += dstPixelStride;
                    srcPixelOffset += srcPixelStride;
                }
                dstLineOffset += dstLineStride;
                srcLineOffset += srcLineStride;
            }
        }
    }

    private synchronized void initByteTable() {
        if (this.byteTable != null) {
            return;
        }
        int numBands = this.getSampleModel().getNumBands();
        this.byteTable = new byte[numBands][256];
        for (int b2 = 0; b2 < numBands; ++b2) {
            double l = this.low[b2];
            double h2 = this.high[b2];
            byte c2 = (byte)this.constants[b2];
            byte[] t = this.byteTable[b2];
            for (int i = 0; i < 256; ++i) {
                t[i] = (double)i >= l && (double)i <= h2 ? c2 : (byte)i;
            }
        }
    }
}

