/*
 * Decompiled with CFR 0.152.
 */
package io.github.geniot.indexedtreemap;

import io.github.geniot.indexedtreemap.IndexedNavigableMap;
import io.github.geniot.indexedtreemap.IndexedNavigableSet;
import io.github.geniot.indexedtreemap.IndexedTreeMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedSet;

public class IndexedTreeSet<E>
extends AbstractSet<E>
implements IndexedNavigableSet<E>,
Cloneable,
Serializable {
    private transient NavigableMap<E, Object> m;
    private static final Object PRESENT = new Object();
    private static final long serialVersionUID = -2479143000061671589L;

    IndexedTreeSet(NavigableMap<E, Object> m3) {
        this.m = m3;
    }

    public IndexedTreeSet() {
        this(new IndexedTreeMap());
    }

    public IndexedTreeSet(Comparator<? super E> comparator) {
        this(new IndexedTreeMap(comparator));
    }

    public IndexedTreeSet(Collection<? extends E> c2) {
        this();
        this.addAll(c2);
    }

    public IndexedTreeSet(SortedSet<E> s2) {
        this(s2.comparator());
        this.addAll(s2);
    }

    @Override
    public Iterator<E> iterator() {
        return this.m.navigableKeySet().iterator();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.m.descendingKeySet().iterator();
    }

    @Override
    public NavigableSet<E> descendingSet() {
        return new IndexedTreeSet<E>(this.m.descendingMap());
    }

    @Override
    public int size() {
        return this.m.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.m.containsKey(o);
    }

    @Override
    public boolean add(E e2) {
        return this.m.put(e2, PRESENT) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.m.remove(o) == PRESENT;
    }

    @Override
    public void clear() {
        this.m.clear();
    }

    @Override
    public boolean addAll(Collection<? extends E> c2) {
        if (this.m.size() == 0 && c2.size() > 0 && c2 instanceof SortedSet && this.m instanceof IndexedTreeMap) {
            Comparator mc;
            SortedSet set = (SortedSet)c2;
            IndexedTreeMap map = (IndexedTreeMap)this.m;
            Comparator cc = set.comparator();
            if (cc == (mc = map.comparator()) || cc != null && cc.equals(mc)) {
                map.addAllForTreeSet(set, PRESENT);
                return true;
            }
        }
        return super.addAll(c2);
    }

    @Override
    public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return new IndexedTreeSet<E>(this.m.subMap(fromElement, fromInclusive, toElement, toInclusive));
    }

    @Override
    public NavigableSet<E> headSet(E toElement, boolean inclusive) {
        return new IndexedTreeSet<E>(this.m.headMap(toElement, inclusive));
    }

    @Override
    public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        return new IndexedTreeSet<E>(this.m.tailMap(fromElement, inclusive));
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        return this.subSet(fromElement, true, toElement, false);
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        return this.headSet(toElement, false);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        return this.tailSet(fromElement, true);
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.m.comparator();
    }

    @Override
    public E first() {
        return (E)this.m.firstKey();
    }

    @Override
    public E last() {
        return (E)this.m.lastKey();
    }

    @Override
    public E lower(E e2) {
        return this.m.lowerKey(e2);
    }

    @Override
    public E floor(E e2) {
        return this.m.floorKey(e2);
    }

    @Override
    public E ceiling(E e2) {
        return this.m.ceilingKey(e2);
    }

    @Override
    public E higher(E e2) {
        return this.m.higherKey(e2);
    }

    @Override
    public E pollFirst() {
        Map.Entry<E, Object> e2 = this.m.pollFirstEntry();
        return e2 == null ? null : (E)e2.getKey();
    }

    @Override
    public E pollLast() {
        Map.Entry<E, Object> e2 = this.m.pollLastEntry();
        return e2 == null ? null : (E)e2.getKey();
    }

    public Object clone() {
        IndexedTreeSet clone = null;
        try {
            clone = (IndexedTreeSet)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new InternalError();
        }
        clone.m = new IndexedTreeMap<E, Object>(this.m);
        return clone;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        s2.writeObject(this.m.comparator());
        s2.writeInt(this.m.size());
        Iterator i = this.m.keySet().iterator();
        while (i.hasNext()) {
            s2.writeObject(i.next());
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        Comparator c2 = (Comparator)s2.readObject();
        IndexedTreeMap<Object, Object> tm = c2 == null ? new IndexedTreeMap<E, Object>() : new IndexedTreeMap(c2);
        this.m = tm;
        int size = s2.readInt();
        tm.readTreeSet(size, s2, PRESENT);
    }

    @Override
    public E exact(int index) {
        Map.Entry e2 = ((IndexedNavigableMap)this.m).exactEntry(index);
        return e2 == null ? null : (E)e2.getKey();
    }

    @Override
    public int entryIndex(E e2) {
        return ((IndexedNavigableMap)this.m).keyIndex(e2);
    }

    public void debug() throws Exception {
        IndexedTreeMap.Entry e2 = ((IndexedTreeMap)this.m).getFirstEntry();
        while (e2 != null) {
            if (e2.weight != e2.sumup()) {
                throw new Exception("Weight is incorrect:" + e2.weight + "!=" + e2.sumup() + " for " + e2.key);
            }
            IndexedTreeMap cfr_ignored_0 = (IndexedTreeMap)this.m;
            e2 = IndexedTreeMap.successor(e2);
        }
    }
}

