/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.cog;

public class PropertyLocator {
    public static String getPropertyValue(String key, String defaultValue) {
        String value = System.getProperty(key);
        if (null != value) {
            return value;
        }
        String environmentKey = PropertyLocator.convertPropertyToEnvVar(key);
        value = System.getenv(environmentKey);
        if (null != value) {
            return value;
        }
        return defaultValue;
    }

    public static String getEnvironmentValue(String key, String defaultValue) {
        String value = System.getenv(key);
        if (null != value) {
            return value;
        }
        String propertyKey = PropertyLocator.convertEnvVarToProperty(key);
        value = System.getProperty(propertyKey);
        if (null != value) {
            return value;
        }
        return defaultValue;
    }

    public static String convertEnvVarToProperty(String envVar) {
        return envVar.toLowerCase().replace("_", ".");
    }

    public static String convertPropertyToEnvVar(String property) {
        return property.toUpperCase().replace(".", "_").replace("-", "_");
    }
}

