/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.stats;

import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.stats.Statistics;
import it.geosolutions.jaiext.stats.StatisticsOpImage;
import it.geosolutions.jaiext.stats.StatsFactory;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import javax.media.jai.ROI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.iterator.RandomIter;

public class ComplexStatsOpImage
extends StatisticsOpImage {
    public ComplexStatsOpImage(RenderedImage source, int xPeriod, int yPeriod, ROI roi, Range noData, boolean useROIAccessor, int[] bands, Statistics.StatsType[] statsTypes, double[] minBound, double[] maxBound, int[] numBins) {
        super(source, xPeriod, yPeriod, roi, noData, useROIAccessor, bands, statsTypes, minBound, maxBound, numBins);
        if (statsTypes != null) {
            for (int i = 0; i < statsTypes.length; ++i) {
                if (statsTypes[i].getStatsId() >= 6) continue;
                throw new IllegalArgumentException("Wrong statistic types");
            }
        } else {
            throw new IllegalArgumentException("Statistic types not present");
        }
        this.statsTypes = statsTypes;
        this.statNum = statsTypes.length;
        this.bands = bands;
        int[] numB = new int[this.bandsNumber];
        double[] lowValue = new double[this.bandsNumber];
        double[] highValue = new double[this.bandsNumber];
        for (int b2 = 0; b2 < this.bandsNumber; ++b2) {
            numB[b2] = numBins.length == 1 ? numBins[0] : numBins[b2];
            lowValue[b2] = minBound.length == 1 ? minBound[0] : minBound[b2];
            highValue[b2] = maxBound.length == 1 ? maxBound[0] : maxBound[b2];
        }
        this.stats = new Statistics[this.selectedBands][this.statNum];
        for (int i = 0; i < this.selectedBands; ++i) {
            for (int j = 0; j < this.statNum; ++j) {
                this.stats[i][j] = StatsFactory.createComplexStatisticsObjectFromInt(statsTypes[j].getStatsId(), lowValue[i], highValue[i], numB[i]);
            }
        }
    }

    @Override
    public Raster computeTile(int tileX, int tileY) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = this.getSourceImage(0).getTile(tileX, tileY);
        if (this.xPeriod > this.getTileWidth() || this.yPeriod > this.getTileHeight()) {
            return source;
        }
        Rectangle srcRect = this.getSourceImage(0).getBounds().intersection(source.getBounds());
        RasterAccessor src = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor roi = null;
        RandomIter roiIter = null;
        if (this.useROIAccessor) {
            Raster roiRaster = null;
            roiRaster = this.srcROIImage.getBounds().contains(srcRect) ? this.srcROIImage.getData(srcRect) : this.srcROIImgExt.getData(srcRect);
            roi = new RasterAccessor(roiRaster, srcRect, RasterAccessor.findCompatibleTags(new RenderedImage[]{this.srcROIImage}, this.srcROIImage)[0], this.srcROIImage.getColorModel());
        } else if (this.hasROI) {
            roiIter = RandomIterFactory.create(this.srcROIImage, this.srcROIImage.getBounds(), true, true);
        }
        switch (src.getDataType()) {
            case 0: {
                this.byteLoop(src, srcRect, roi, this.stats, roiIter);
                break;
            }
            case 1: {
                this.ushortLoop(src, srcRect, roi, this.stats, roiIter);
                break;
            }
            case 2: {
                this.shortLoop(src, srcRect, roi, this.stats, roiIter);
                break;
            }
            case 3: {
                this.intLoop(src, srcRect, roi, this.stats, roiIter);
                break;
            }
            case 4: {
                this.floatLoop(src, srcRect, roi, this.stats, roiIter);
                break;
            }
            case 5: {
                this.doubleLoop(src, srcRect, roi, this.stats, roiIter);
            }
        }
        return source;
    }
}

