/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.utilities.shape;

import it.geosolutions.jaiext.utilities.shape.AbstractLiteIterator;
import it.geosolutions.jaiext.utilities.shape.EmptyIterator;
import it.geosolutions.jaiext.utilities.shape.LineIterator;
import it.geosolutions.jaiext.utilities.shape.PointIterator;
import it.geosolutions.jaiext.utilities.shape.PolygonIterator;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public final class GeomCollectionIterator
extends AbstractLiteIterator {
    private AffineTransform at;
    private GeometryCollection gc;
    private int currentGeom;
    private PathIterator currentIterator;
    private boolean done = false;

    public GeomCollectionIterator() {
    }

    public void init(GeometryCollection gc, AffineTransform at) {
        this.gc = gc;
        this.at = at == null ? new AffineTransform() : at;
        this.currentGeom = 0;
        this.done = false;
        this.currentIterator = gc.isEmpty() ? EmptyIterator.INSTANCE : this.getIterator(gc.getGeometryN(0));
    }

    public GeomCollectionIterator(GeometryCollection gc, AffineTransform at) {
        this.init(gc, at);
    }

    private AbstractLiteIterator getIterator(Geometry g2) {
        AbstractLiteIterator pi = null;
        if (g2.isEmpty()) {
            return EmptyIterator.INSTANCE;
        }
        if (g2 instanceof Polygon) {
            Polygon p = (Polygon)g2;
            pi = new PolygonIterator(p, this.at);
        } else if (g2 instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)g2;
            pi = new GeomCollectionIterator(gc, this.at);
        } else if (g2 instanceof LineString || g2 instanceof LinearRing) {
            LineString ls = (LineString)g2;
            pi = new LineIterator(ls, this.at);
        } else if (g2 instanceof Point) {
            Point p = (Point)g2;
            pi = new PointIterator(p, this.at);
        }
        return pi;
    }

    @Override
    public int currentSegment(double[] coords) {
        return this.currentIterator.currentSegment(coords);
    }

    @Override
    public int currentSegment(float[] coords) {
        return this.currentIterator.currentSegment(coords);
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public void next() {
        if (!this.currentIterator.isDone()) {
            this.currentIterator.next();
        }
        while (this.currentIterator.isDone() && !this.done) {
            if (this.currentGeom < this.gc.getNumGeometries() - 1) {
                ++this.currentGeom;
                this.currentIterator = this.getIterator(this.gc.getGeometryN(this.currentGeom));
                continue;
            }
            this.done = true;
        }
    }
}

