/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Rectangle;
import java.awt.image.Raster;

public final class UnpackedImageData {
    public final Raster raster;
    public final Rectangle rect;
    public final int type;
    public final Object data;
    public final int pixelStride;
    public final int lineStride;
    public final int[] bandOffsets;
    public final boolean convertToDest;

    public UnpackedImageData(Raster raster, Rectangle rect, int type, Object data, int pixelStride, int lineStride, int[] bandOffsets, boolean convertToDest) {
        this.raster = raster;
        this.rect = rect;
        this.type = type;
        this.data = data;
        this.pixelStride = pixelStride;
        this.lineStride = lineStride;
        this.bandOffsets = bandOffsets;
        this.convertToDest = convertToDest;
    }

    public byte[][] getByteData() {
        return this.type == 0 ? (byte[][])this.data : (byte[][])null;
    }

    public byte[] getByteData(int b2) {
        byte[][] d2 = this.getByteData();
        return d2 == null ? null : d2[b2];
    }

    public short[][] getShortData() {
        return this.type == 1 || this.type == 2 ? (short[][])this.data : (short[][])null;
    }

    public short[] getShortData(int b2) {
        short[][] d2 = this.getShortData();
        return d2 == null ? null : d2[b2];
    }

    public int[][] getIntData() {
        return this.type == 3 ? (int[][])this.data : (int[][])null;
    }

    public int[] getIntData(int b2) {
        int[][] d2 = this.getIntData();
        return d2 == null ? null : d2[b2];
    }

    public float[][] getFloatData() {
        return this.type == 4 ? (float[][])this.data : (float[][])null;
    }

    public float[] getFloatData(int b2) {
        float[][] d2 = this.getFloatData();
        return d2 == null ? null : d2[b2];
    }

    public double[][] getDoubleData() {
        return this.type == 5 ? (double[][])this.data : (double[][])null;
    }

    public double[] getDoubleData(int b2) {
        double[][] d2 = this.getDoubleData();
        return d2 == null ? null : d2[b2];
    }

    public int getOffset(int b2) {
        return this.bandOffsets[b2];
    }

    public int getMinOffset() {
        int min2 = this.bandOffsets[0];
        for (int i = 1; i < this.bandOffsets.length; ++i) {
            min2 = Math.min(min2, this.bandOffsets[i]);
        }
        return min2;
    }

    public int getMaxOffset() {
        int max = this.bandOffsets[0];
        for (int i = 1; i < this.bandOffsets.length; ++i) {
            max = Math.max(max, this.bandOffsets[i]);
        }
        return max;
    }
}

