/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints;

import org.chocosolver.solver.ISelf;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.binary.PropGreaterOrEqualX_Y;
import org.chocosolver.solver.constraints.graph.basic.PropAntiSymmetric;
import org.chocosolver.solver.constraints.graph.basic.PropDiameter;
import org.chocosolver.solver.constraints.graph.basic.PropLoopSet;
import org.chocosolver.solver.constraints.graph.basic.PropNbCliques;
import org.chocosolver.solver.constraints.graph.basic.PropNbEdges;
import org.chocosolver.solver.constraints.graph.basic.PropNbLoops;
import org.chocosolver.solver.constraints.graph.basic.PropNbNodes;
import org.chocosolver.solver.constraints.graph.basic.PropSymmetric;
import org.chocosolver.solver.constraints.graph.basic.PropTransitivity;
import org.chocosolver.solver.constraints.graph.channeling.edges.PropEdgeBoolChannel;
import org.chocosolver.solver.constraints.graph.channeling.edges.PropNeighBoolChannel;
import org.chocosolver.solver.constraints.graph.channeling.edges.PropNeighBoolsChannel1;
import org.chocosolver.solver.constraints.graph.channeling.edges.PropNeighBoolsChannel2;
import org.chocosolver.solver.constraints.graph.channeling.edges.PropNeighSetChannel;
import org.chocosolver.solver.constraints.graph.channeling.edges.PropNeighSetsChannel1;
import org.chocosolver.solver.constraints.graph.channeling.edges.PropNeighSetsChannel2;
import org.chocosolver.solver.constraints.graph.channeling.nodes.PropNodeBoolChannel;
import org.chocosolver.solver.constraints.graph.channeling.nodes.PropNodeBoolsChannel;
import org.chocosolver.solver.constraints.graph.channeling.nodes.PropNodeSetChannel;
import org.chocosolver.solver.constraints.graph.connectivity.PropBiconnected;
import org.chocosolver.solver.constraints.graph.connectivity.PropConnected;
import org.chocosolver.solver.constraints.graph.connectivity.PropNbCC;
import org.chocosolver.solver.constraints.graph.connectivity.PropNbSCC;
import org.chocosolver.solver.constraints.graph.connectivity.PropSizeMaxCC;
import org.chocosolver.solver.constraints.graph.connectivity.PropSizeMinCC;
import org.chocosolver.solver.constraints.graph.cost.trees.PropMaxDegVarTree;
import org.chocosolver.solver.constraints.graph.cost.trees.PropTreeCostSimple;
import org.chocosolver.solver.constraints.graph.cost.trees.lagrangian.PropGenericLagrDCMST;
import org.chocosolver.solver.constraints.graph.cost.tsp.PropCycleCostSimple;
import org.chocosolver.solver.constraints.graph.cost.tsp.lagrangian.PropLagrOneTree;
import org.chocosolver.solver.constraints.graph.cycles.PropAcyclic;
import org.chocosolver.solver.constraints.graph.cycles.PropCycle;
import org.chocosolver.solver.constraints.graph.degree.PropNodeDegreeAtLeastIncr;
import org.chocosolver.solver.constraints.graph.degree.PropNodeDegreeAtMostIncr;
import org.chocosolver.solver.constraints.graph.degree.PropNodeDegreeVar;
import org.chocosolver.solver.constraints.graph.inclusion.PropInclusion;
import org.chocosolver.solver.constraints.graph.symmbreaking.PropIncrementalAdjacencyMatrix;
import org.chocosolver.solver.constraints.graph.symmbreaking.PropIncrementalAdjacencyUndirectedMatrix;
import org.chocosolver.solver.constraints.graph.symmbreaking.PropSymmetryBreaking;
import org.chocosolver.solver.constraints.graph.symmbreaking.PropSymmetryBreakingEx;
import org.chocosolver.solver.constraints.graph.tree.PropArborescence;
import org.chocosolver.solver.constraints.graph.tree.PropArborescences;
import org.chocosolver.solver.constraints.graph.tree.PropReachability;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.DirectedGraphVar;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.solver.variables.IncidentSet;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.UndirectedGraphVar;
import org.chocosolver.util.objects.graphs.Orientation;
import org.chocosolver.util.tools.ArrayUtils;

public interface IGraphConstraintFactory
extends ISelf<Model> {
    default public Constraint nbNodes(GraphVar g2, IntVar nb) {
        return new Constraint("nbNodes", new PropNbNodes(g2, nb));
    }

    default public Constraint nbEdges(GraphVar g2, IntVar nb) {
        return new Constraint("nbEdges", new PropNbEdges(g2, nb));
    }

    default public Constraint loopSet(GraphVar g2, SetVar loops) {
        return new Constraint("loopSet", new PropLoopSet(g2, loops));
    }

    default public Constraint nbLoops(GraphVar g2, IntVar nb) {
        return new Constraint("nbLoops", new PropNbLoops(g2, nb));
    }

    default public Constraint symmetric(DirectedGraphVar g2) {
        return new Constraint("symmetric", new PropSymmetric(g2));
    }

    default public Constraint antisymmetric(DirectedGraphVar g2) {
        return new Constraint("antisymmetric", new PropAntiSymmetric(g2));
    }

    default public Constraint transitivity(GraphVar g2) {
        return new Constraint("transitivity", new PropTransitivity<GraphVar>(g2));
    }

    default public Constraint subgraph(UndirectedGraphVar g1, UndirectedGraphVar g2) {
        return new Constraint("subgraph", new PropInclusion(g1, g2));
    }

    default public Constraint subgraph(DirectedGraphVar g1, DirectedGraphVar g2) {
        return new Constraint("subgraph", new PropInclusion(g1, g2));
    }

    default public Constraint nodesChanneling(GraphVar g2, SetVar nodes) {
        return new Constraint("nodesSetChanneling", new PropNodeSetChannel(nodes, g2));
    }

    default public Constraint nodesChanneling(GraphVar g2, BoolVar[] nodes) {
        return new Constraint("nodesBoolsChanneling", new PropNodeBoolsChannel(nodes, g2));
    }

    default public Constraint nodeChanneling(GraphVar g2, BoolVar isIn, int vertex) {
        return new Constraint("nodesBoolChanneling", new PropNodeBoolChannel(isIn, vertex, g2));
    }

    default public Constraint edgeChanneling(DirectedGraphVar g2, BoolVar isEdge, int from, int to) {
        return new Constraint("edgeChanneling", new PropEdgeBoolChannel(isEdge, from, to, g2));
    }

    default public Constraint edgeChanneling(UndirectedGraphVar g2, BoolVar isEdge, int i, int j) {
        return new Constraint("edgeChanneling", new PropEdgeBoolChannel(isEdge, i, j, g2));
    }

    default public Constraint neighborsChanneling(UndirectedGraphVar g2, SetVar[] neighbors) {
        return new Constraint("neighSetsChanneling", new PropNeighSetsChannel1(neighbors, g2), new PropNeighSetsChannel2(neighbors, g2));
    }

    default public Constraint neighborsChanneling(UndirectedGraphVar g2, BoolVar[][] neighbors) {
        return new Constraint("neighBoolsChanneling", new PropNeighBoolsChannel1(neighbors, g2), new PropNeighBoolsChannel2(neighbors, g2));
    }

    default public Constraint neighborsChanneling(UndirectedGraphVar g2, SetVar neighborsOf, int node) {
        return new Constraint("neighSetChanneling", new PropNeighSetChannel(neighborsOf, node, g2, new IncidentSet.SuccessorsSet()));
    }

    default public Constraint neighborsChanneling(UndirectedGraphVar g2, BoolVar[] neighborsOf, int node) {
        return new Constraint("neighBoolChanneling", new PropNeighBoolChannel(neighborsOf, node, g2, new IncidentSet.SuccessorsSet()));
    }

    default public Constraint successorsChanneling(DirectedGraphVar g2, SetVar[] successors) {
        return new Constraint("succSetsChanneling", new PropNeighSetsChannel1(successors, g2), new PropNeighSetsChannel2(successors, g2));
    }

    default public Constraint successorsChanneling(DirectedGraphVar g2, BoolVar[][] successors) {
        return new Constraint("succBoolsChanneling", new PropNeighBoolsChannel1(successors, g2), new PropNeighBoolsChannel2(successors, g2));
    }

    default public Constraint successorsChanneling(DirectedGraphVar g2, SetVar successorsOf, int node) {
        return new Constraint("succSetChanneling", new PropNeighSetChannel(successorsOf, node, g2, new IncidentSet.SuccessorsSet()));
    }

    default public Constraint successorsChanneling(DirectedGraphVar g2, BoolVar[] successorsOf, int node) {
        return new Constraint("succBoolChanneling", new PropNeighBoolChannel(successorsOf, node, g2, new IncidentSet.SuccessorsSet()));
    }

    default public Constraint predecessorsChanneling(DirectedGraphVar g2, SetVar predecessorsOf, int node) {
        return new Constraint("predSetChanneling", new PropNeighSetChannel(predecessorsOf, node, g2, new IncidentSet.PredecessorsSet()));
    }

    default public Constraint predecessorsChanneling(DirectedGraphVar g2, BoolVar[] predecessorsOf, int node) {
        return new Constraint("predBoolChanneling", new PropNeighBoolChannel(predecessorsOf, node, g2, new IncidentSet.PredecessorsSet()));
    }

    default public Constraint minDegree(UndirectedGraphVar g2, int minDegree) {
        return new Constraint("minDegree", new PropNodeDegreeAtLeastIncr(g2, minDegree));
    }

    default public Constraint minDegrees(UndirectedGraphVar g2, int[] minDegrees) {
        return new Constraint("minDegrees", new PropNodeDegreeAtLeastIncr(g2, minDegrees));
    }

    default public Constraint maxDegree(UndirectedGraphVar g2, int maxDegree) {
        return new Constraint("maxDegree", new PropNodeDegreeAtMostIncr(g2, maxDegree));
    }

    default public Constraint maxDegrees(UndirectedGraphVar g2, int[] maxDegrees) {
        return new Constraint("maxDegrees", new PropNodeDegreeAtMostIncr(g2, maxDegrees));
    }

    default public Constraint degrees(UndirectedGraphVar g2, IntVar[] degrees2) {
        return new Constraint("degrees", new PropNodeDegreeVar(g2, degrees2));
    }

    default public Constraint minInDegree(DirectedGraphVar g2, int minDegree) {
        return new Constraint("minInDegree", new PropNodeDegreeAtLeastIncr(g2, Orientation.PREDECESSORS, minDegree));
    }

    default public Constraint minInDegrees(DirectedGraphVar g2, int[] minDegrees) {
        return new Constraint("minInDegrees", new PropNodeDegreeAtLeastIncr(g2, Orientation.PREDECESSORS, minDegrees));
    }

    default public Constraint maxInDegree(DirectedGraphVar g2, int maxDegree) {
        return new Constraint("maxInDegree", new PropNodeDegreeAtMostIncr(g2, Orientation.PREDECESSORS, maxDegree));
    }

    default public Constraint maxInDegrees(DirectedGraphVar g2, int[] maxDegrees) {
        return new Constraint("maxInDegrees", new PropNodeDegreeAtMostIncr(g2, Orientation.PREDECESSORS, maxDegrees));
    }

    default public Constraint inDegrees(DirectedGraphVar g2, IntVar[] degrees2) {
        return new Constraint("inDegrees", new PropNodeDegreeVar(g2, Orientation.PREDECESSORS, degrees2));
    }

    default public Constraint minOutDegree(DirectedGraphVar g2, int minDegree) {
        return new Constraint("minOutDegrees", new PropNodeDegreeAtLeastIncr(g2, Orientation.SUCCESSORS, minDegree));
    }

    default public Constraint minOutDegrees(DirectedGraphVar g2, int[] minDegrees) {
        return new Constraint("minOutDegrees", new PropNodeDegreeAtLeastIncr(g2, Orientation.SUCCESSORS, minDegrees));
    }

    default public Constraint maxOutDegree(DirectedGraphVar g2, int maxDegree) {
        return new Constraint("maxOutDegrees", new PropNodeDegreeAtMostIncr(g2, Orientation.SUCCESSORS, maxDegree));
    }

    default public Constraint maxOutDegrees(DirectedGraphVar g2, int[] maxDegrees) {
        return new Constraint("maxOutDegrees", new PropNodeDegreeAtMostIncr(g2, Orientation.SUCCESSORS, maxDegrees));
    }

    default public Constraint outDegrees(DirectedGraphVar g2, IntVar[] degrees2) {
        return new Constraint("outDegrees", new PropNodeDegreeVar(g2, Orientation.SUCCESSORS, degrees2));
    }

    default public Constraint cycle(UndirectedGraphVar g2) {
        int m3 = 0;
        int n = g2.getNbMaxNodes();
        for (int i = 0; i < n; ++i) {
            m3 += g2.getPotentialNeighborsOf(i).size();
        }
        m3 /= 2;
        PropNodeDegreeAtMostIncr pMaxDeg = new PropNodeDegreeAtMostIncr(g2, 2);
        if (g2.getMandatoryNodes().size() <= 1) {
            IntVar nbNodes = g2.getModel().intVar(g2.getMandatoryNodes().size(), g2.getPotentialNodes().size());
            g2.getModel().ifThenElse(g2.getModel().intGeView(nbNodes, 2), new Constraint("minDeg >= 2", new PropNodeDegreeAtLeastIncr(g2, 2)), new Constraint("minDeg >= 1", new PropNodeDegreeAtLeastIncr(g2, 1)));
            return new Constraint("cycle", new PropNbNodes(g2, nbNodes), pMaxDeg, new PropConnected(g2), new PropCycle(g2));
        }
        return new Constraint("cycle", new PropNodeDegreeAtLeastIncr(g2, 2), pMaxDeg, new PropConnected(g2), new PropCycle(g2));
    }

    default public Constraint noCycle(UndirectedGraphVar g2) {
        return new Constraint("noCycle", new PropAcyclic(g2));
    }

    default public Constraint noCircuit(DirectedGraphVar g2) {
        return new Constraint("noCycle", new PropAcyclic(g2));
    }

    default public Constraint connected(UndirectedGraphVar g2) {
        return new Constraint("connected", new PropConnected(g2));
    }

    default public Constraint biconnected(UndirectedGraphVar g2) {
        return new Constraint("connected", new PropBiconnected(g2));
    }

    default public Constraint nbConnectedComponents(UndirectedGraphVar g2, IntVar nb) {
        return new Constraint("NbCC", new PropNbCC(g2, nb));
    }

    default public Constraint sizeConnectedComponents(UndirectedGraphVar g2, IntVar sizeMinCC, IntVar sizeMaxCC) {
        return new Constraint("SizeCC", new PropGreaterOrEqualX_Y(new IntVar[]{sizeMaxCC, sizeMinCC}), new PropSizeMinCC(g2, sizeMinCC), new PropSizeMaxCC(g2, sizeMaxCC));
    }

    default public Constraint sizeMinConnectedComponents(UndirectedGraphVar g2, IntVar sizeMinCC) {
        return new Constraint("SizeMinCC", new PropSizeMinCC(g2, sizeMinCC));
    }

    default public Constraint sizeMaxConnectedComponents(UndirectedGraphVar g2, IntVar sizeMaxCC) {
        return new Constraint("SizeMaxCC", new PropSizeMaxCC(g2, sizeMaxCC));
    }

    default public Constraint stronglyConnected(DirectedGraphVar g2) {
        return this.nbStronglyConnectedComponents(g2, g2.getModel().intVar(1));
    }

    default public Constraint nbStronglyConnectedComponents(DirectedGraphVar g2, IntVar nb) {
        return new Constraint("NbSCC", new PropNbSCC(g2, nb));
    }

    default public Constraint tree(UndirectedGraphVar g2) {
        return new Constraint("tree", new PropAcyclic(g2), new PropConnected(g2));
    }

    default public Constraint forest(UndirectedGraphVar g2) {
        return new Constraint("forest", new PropAcyclic(g2));
    }

    default public Constraint directedTree(DirectedGraphVar g2, int root) {
        int n = g2.getNbMaxNodes();
        int[] nbPreds = new int[n];
        for (int i = 0; i < n; ++i) {
            nbPreds[i] = 1;
        }
        nbPreds[root] = 0;
        return new Constraint("directedTree", new PropArborescence(g2, root), new PropNodeDegreeAtMostIncr(g2, Orientation.PREDECESSORS, nbPreds), new PropNodeDegreeAtLeastIncr(g2, Orientation.PREDECESSORS, nbPreds));
    }

    default public Constraint directedForest(DirectedGraphVar g2) {
        return new Constraint("directedForest", new PropArborescences(g2), new PropNodeDegreeAtMostIncr(g2, Orientation.PREDECESSORS, 1));
    }

    default public Constraint reachability(DirectedGraphVar g2, int root) {
        return new Constraint("reachability_from_" + root, new PropReachability(g2, root));
    }

    default public Constraint nbCliques(UndirectedGraphVar g2, IntVar nb) {
        return new Constraint("NbCliques", new PropTransitivity<UndirectedGraphVar>(g2), new PropNbCC(g2, nb), new PropNbCliques(g2, nb));
    }

    default public Constraint diameter(UndirectedGraphVar g2, IntVar d2) {
        return new Constraint("diameter", new PropConnected(g2), new PropDiameter(g2, d2));
    }

    default public Constraint diameter(DirectedGraphVar g2, IntVar d2) {
        return new Constraint("NbCliques", new PropNbSCC(g2, g2.getModel().intVar(1)), new PropDiameter(g2, d2));
    }

    default public Constraint tsp(UndirectedGraphVar graphVar, IntVar costVar, int[][] edgeCosts, int lagrMode) {
        Propagator[] props = ArrayUtils.append(this.cycle(graphVar).getPropagators(), {new PropCycleCostSimple(graphVar, costVar, edgeCosts)});
        if (lagrMode > 0) {
            PropLagrOneTree hk = new PropLagrOneTree(graphVar, costVar, edgeCosts);
            hk.waitFirstSolution(lagrMode == 2);
            props = ArrayUtils.append(props, {hk});
        }
        return new Constraint("TSP", props);
    }

    default public Constraint dcmst(UndirectedGraphVar graphVar, IntVar[] degrees2, IntVar costVar, int[][] edgeCosts, int lagrMode) {
        Propagator[] props = ArrayUtils.append(this.tree(graphVar).getPropagators(), {new PropTreeCostSimple(graphVar, costVar, edgeCosts), new PropMaxDegVarTree(graphVar, degrees2)});
        if (lagrMode > 0) {
            PropGenericLagrDCMST hk = new PropGenericLagrDCMST(graphVar, costVar, degrees2, edgeCosts, lagrMode == 2);
            props = ArrayUtils.append(props, {hk});
        }
        return new Constraint("dcmst", props);
    }

    default public void postSymmetryBreaking(DirectedGraphVar graph) {
        int i;
        Model m3 = (Model)this.ref();
        int n = graph.getNbMaxNodes();
        BoolVar[] t = m3.boolVarArray("T[]", n * n);
        IntVar[] p = new IntVar[n];
        p[0] = m3.intVar("P[0]", 0);
        for (i = 1; i < n; ++i) {
            p[i] = m3.intVar("P[" + i + "]", 0, i - 1);
        }
        new Constraint("AdjacencyMatrix", new PropIncrementalAdjacencyMatrix(graph, t)).post();
        for (i = 0; i < n - 1; ++i) {
            IntVar I = m3.intVar(i);
            for (int j = 1; j < n; ++j) {
                BoolVar[] clause = new BoolVar[i + 1];
                clause[i] = t[i + j * n];
                for (int k = 0; k < i; ++k) {
                    clause[k] = t[k + j * n].not();
                }
                Constraint c2 = m3.and(clause);
                Constraint pij = m3.arithm(p[j], "=", I);
                m3.ifThen(pij, c2);
                m3.ifThen(c2, pij);
            }
        }
        for (i = 1; i < n - 1; ++i) {
            m3.arithm(p[i], "<=", p[i + 1]).post();
        }
    }

    default public void postSymmetryBreaking(UndirectedGraphVar graph) {
        int i;
        Model m3 = (Model)this.ref();
        int n = graph.getNbMaxNodes();
        BoolVar[] t = m3.boolVarArray("T[]", n * n);
        IntVar[] p = new IntVar[n];
        p[0] = m3.intVar("P[0]", 0);
        for (i = 1; i < n; ++i) {
            p[i] = m3.intVar("P[" + i + "]", 0, i - 1);
        }
        new Constraint("AdjacencyMatrix", new PropIncrementalAdjacencyUndirectedMatrix(graph, t)).post();
        for (i = 0; i < n - 1; ++i) {
            IntVar I = m3.intVar(i);
            for (int j = 1; j < n; ++j) {
                BoolVar[] clause = new BoolVar[i + 1];
                clause[i] = t[i + j * n];
                for (int k = 0; k < i; ++k) {
                    clause[k] = t[k + j * n].not();
                }
                Constraint c2 = m3.and(clause);
                Constraint pij = m3.arithm(p[j], "=", I);
                m3.ifThen(pij, c2);
                m3.ifThen(c2, pij);
            }
        }
        for (i = 1; i < n - 1; ++i) {
            m3.arithm(p[i], "<=", p[i + 1]).post();
        }
    }

    default public Constraint symmetryBreaking2(UndirectedGraphVar graph) {
        int n = graph.getNbMaxNodes();
        BoolVar[] t = ((Model)this.ref()).boolVarArray("T[]", n * n);
        return new Constraint("symmBreak", new PropIncrementalAdjacencyUndirectedMatrix(graph, t), new PropSymmetryBreaking(t));
    }

    default public Constraint symmetryBreaking3(UndirectedGraphVar graph) {
        int n = graph.getNbMaxNodes();
        BoolVar[] t = ((Model)this.ref()).boolVarArray("T[]", n * n);
        return new Constraint("symmBreakEx", new PropIncrementalAdjacencyUndirectedMatrix(graph, t), new PropSymmetryBreakingEx(t));
    }
}

