/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.automata.structure.multicostregular;

import gnu.trove.stack.TIntStack;
import java.util.Arrays;
import org.chocosolver.solver.constraints.nary.automata.PropMultiCostRegular;
import org.chocosolver.solver.constraints.nary.automata.structure.multicostregular.StoredDirectedMultiGraph;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.objects.StoredIndexedBipartiteSetWithOffset;

public class FastPathFinder {
    private final StoredDirectedMultiGraph graph;
    private final int[] sp;
    private final int nbLayer;
    private final int nbR;
    public double[][] spfs;
    public double[][] spft;
    private final double[][] lpfs;
    private final double[][] lpft;
    private final boolean[] modified = new boolean[2];
    private final int[][] prevSP;
    private final int[][] nextSP;
    private final int[][] prevLP;
    private final int[][] nextLP;
    private final double[] tmpU;

    public FastPathFinder(StoredDirectedMultiGraph graph) {
        this.graph = graph;
        this.sp = new int[graph.layers.length - 1];
        this.nbLayer = graph.layers.length - 1;
        this.nbR = this.graph.nbR - 1;
        this.tmpU = new double[this.nbR];
        this.spfs = this.graph.GNodes.spfsI;
        this.spft = this.graph.GNodes.spftI;
        this.lpfs = this.graph.GNodes.lpfsI;
        this.lpft = this.graph.GNodes.lpftI;
        this.prevSP = this.graph.GNodes.prevSPI;
        this.nextSP = this.graph.GNodes.nextSPI;
        this.prevLP = this.graph.GNodes.prevLPI;
        this.nextLP = this.graph.GNodes.nextLPI;
    }

    private double getCost(int e2, int resource, double[] u, boolean lagrange, boolean max) {
        double cost;
        if (!lagrange) {
            cost = this.graph.GArcs.originalCost[e2][resource];
        } else {
            double tmp = 0.0;
            for (int k = 1; k <= this.nbR; ++k) {
                tmp += u[k - 1] * this.graph.GArcs.originalCost[e2][k];
            }
            if (max) {
                tmp = -tmp;
            }
            cost = this.graph.GArcs.originalCost[e2][0] + tmp;
        }
        this.graph.GArcs.temporaryCost[e2] = cost;
        return cost;
    }

    private double[] simplifyLagrangian(double[] u) {
        for (int k = 1; k <= this.nbR; ++k) {
            this.tmpU[k - 1] = u[k - 1] - u[k - 1 + this.nbR];
        }
        return this.tmpU;
    }

    private static boolean isAllZero(double[] u) {
        for (double d2 : u) {
            if (d2 == 0.0) continue;
            return false;
        }
        return true;
    }

    public void computeLongestPath(TIntStack removed, double lb, double[] u, boolean lagrange, boolean max, int resource, PropMultiCostRegular propagator) throws ContradictionException {
        double newCost;
        int e2;
        int x;
        StoredIndexedBipartiteSetWithOffset bs;
        int w;
        int size;
        int[] list;
        boolean update;
        int i;
        if (lagrange) {
            if (FastPathFinder.isAllZero(u)) {
                u = null;
                lagrange = false;
                resource = 0;
            } else {
                u = this.simplifyLagrangian(u);
            }
        }
        this.graph.GNodes.lpfs[this.graph.sourceIndex] = 0.0;
        this.graph.GNodes.lpft[this.graph.tinIndex] = 0.0;
        for (i = 1; i <= this.nbLayer; ++i) {
            update = false;
            list = this.graph.layers[i]._getStructure();
            size = this.graph.layers[i].size();
            for (w = size - 1; w >= 0; --w) {
                int dest = list[w];
                bs = this.graph.GNodes.inArcs[dest];
                assert (!bs.isEmpty());
                int[] inlist = bs._getStructure();
                int insize = bs.size();
                this.graph.GNodes.lpfs[dest] = Double.NEGATIVE_INFINITY;
                for (x = 0; x < insize; ++x) {
                    int orig;
                    e2 = inlist[x];
                    if (this.graph.isInStack(e2) || !(this.graph.GNodes.lpfs[dest] < (newCost = this.graph.GNodes.lpfs[orig = this.graph.GArcs.origs[e2]] + this.getCost(e2, resource, u, lagrange, max)))) continue;
                    this.graph.GNodes.lpfs[dest] = newCost;
                    this.graph.GNodes.prevLP[dest] = e2;
                    update = true;
                }
            }
            if (update) continue;
            propagator.fails();
        }
        for (i = this.nbLayer - 1; i >= 0; --i) {
            update = false;
            list = this.graph.layers[i]._getStructure();
            size = this.graph.layers[i].size();
            for (w = size - 1; w >= 0; --w) {
                int orig = list[w];
                bs = this.graph.GNodes.outArcs[orig];
                assert (!bs.isEmpty());
                int[] outlist = bs._getStructure();
                int outsize = bs.size();
                this.graph.GNodes.lpft[orig] = Double.NEGATIVE_INFINITY;
                for (x = 0; x < outsize; ++x) {
                    e2 = outlist[x];
                    if (this.graph.isInStack(e2)) continue;
                    int next = this.graph.GArcs.dests[e2];
                    newCost = this.graph.GNodes.lpft[next] + this.graph.GArcs.temporaryCost[e2];
                    if (newCost + this.graph.GNodes.lpfs[orig] - lb <= -propagator._MCR_DECIMAL_PREC) {
                        this.graph.setInStack(e2);
                        removed.push(e2);
                        continue;
                    }
                    if (!(this.graph.GNodes.lpft[orig] < newCost)) continue;
                    this.graph.GNodes.lpft[orig] = newCost;
                    this.graph.GNodes.nextLP[orig] = e2;
                    update = true;
                }
            }
            if (update) continue;
            propagator.fails();
        }
    }

    public final double getLongestPathValue() {
        return this.graph.GNodes.lpft[this.graph.sourceIndex];
    }

    public int[] getLongestPath() {
        int e2;
        int i = 0;
        int current = this.graph.sourceIndex;
        do {
            e2 = this.graph.GNodes.nextLP[current];
            this.sp[i++] = e2;
        } while (this.graph.GNodes.nextLP[current = this.graph.GArcs.dests[e2]] != Integer.MIN_VALUE);
        return this.sp;
    }

    public void computeShortestPath(TIntStack removed, double ub, double[] u, boolean lagrange, boolean max, int resource, PropMultiCostRegular propagator) throws ContradictionException {
        double newCost;
        int e2;
        int x;
        StoredIndexedBipartiteSetWithOffset bs;
        int w;
        int size;
        int[] list;
        boolean update;
        int i;
        this.graph.GNodes.spfs[this.graph.sourceIndex] = 0.0;
        this.graph.GNodes.spft[this.graph.tinIndex] = 0.0;
        if (lagrange) {
            if (FastPathFinder.isAllZero(u)) {
                u = null;
                lagrange = false;
                resource = 0;
            } else {
                u = this.simplifyLagrangian(u);
            }
        }
        for (i = 1; i <= this.nbLayer; ++i) {
            update = false;
            list = this.graph.layers[i]._getStructure();
            size = this.graph.layers[i].size();
            for (w = size - 1; w >= 0; --w) {
                int dest = list[w];
                this.graph.GNodes.spfs[dest] = Double.POSITIVE_INFINITY;
                bs = this.graph.GNodes.inArcs[dest];
                assert (!bs.isEmpty());
                int[] inlist = bs._getStructure();
                int insize = bs.size();
                for (x = 0; x < insize; ++x) {
                    int orig;
                    e2 = inlist[x];
                    if (this.graph.isInStack(e2) || !(this.graph.GNodes.spfs[dest] > (newCost = this.graph.GNodes.spfs[orig = this.graph.GArcs.origs[e2]] + this.getCost(e2, resource, u, lagrange, max)))) continue;
                    this.graph.GNodes.spfs[dest] = newCost;
                    this.graph.GNodes.prevSP[dest] = e2;
                    update = true;
                }
            }
            if (update) continue;
            propagator.fails();
        }
        for (i = this.nbLayer - 1; i >= 0; --i) {
            update = false;
            list = this.graph.layers[i]._getStructure();
            size = this.graph.layers[i].size();
            for (w = size - 1; w >= 0; --w) {
                int orig = list[w];
                this.graph.GNodes.spft[orig] = Double.POSITIVE_INFINITY;
                bs = this.graph.GNodes.outArcs[orig];
                assert (!bs.isEmpty());
                int[] outlist = bs._getStructure();
                int outsize = bs.size();
                for (x = 0; x < outsize; ++x) {
                    e2 = outlist[x];
                    if (this.graph.isInStack(e2)) continue;
                    int dest = this.graph.GArcs.dests[e2];
                    newCost = this.graph.GNodes.spft[dest] + this.graph.GArcs.temporaryCost[e2];
                    if (newCost + this.graph.GNodes.spfs[orig] - ub >= propagator._MCR_DECIMAL_PREC) {
                        this.graph.setInStack(e2);
                        removed.push(e2);
                        continue;
                    }
                    if (!(this.graph.GNodes.spft[orig] > newCost)) continue;
                    this.graph.GNodes.spft[orig] = newCost;
                    this.graph.GNodes.nextSP[orig] = e2;
                    update = true;
                }
            }
            if (update) continue;
            propagator.fails();
        }
    }

    public final double getShortestPathValue() {
        return this.graph.GNodes.spft[this.graph.sourceIndex];
    }

    public int[] getShortestPath() {
        int e2;
        int i = 0;
        int current = this.graph.sourceIndex;
        do {
            e2 = this.graph.GNodes.nextSP[current];
            this.sp[i++] = e2;
        } while (this.graph.GNodes.nextSP[current = this.graph.GArcs.dests[e2]] != Integer.MIN_VALUE);
        return this.sp;
    }

    public boolean[] computeShortestAndLongestPath(TIntStack removed, IntVar[] z, PropMultiCostRegular propagator) throws ContradictionException {
        int d2;
        double[] cost;
        int e2;
        int x;
        StoredIndexedBipartiteSetWithOffset bs;
        int w;
        int size;
        int[] list;
        boolean update;
        int i;
        int nbr = z.length;
        for (int i2 = 0; i2 < nbr; ++i2) {
            this.spfs[this.graph.sourceIndex][i2] = 0.0;
            this.spft[this.graph.tinIndex][i2] = 0.0;
            this.lpfs[this.graph.sourceIndex][i2] = 0.0;
            this.lpft[this.graph.tinIndex][i2] = 0.0;
        }
        for (i = 1; i <= this.nbLayer; ++i) {
            update = false;
            list = this.graph.layers[i]._getStructure();
            size = this.graph.layers[i].size();
            for (w = size - 1; w >= 0; --w) {
                int dest = list[w];
                Arrays.fill(this.spfs[dest], Double.POSITIVE_INFINITY);
                Arrays.fill(this.lpfs[dest], Double.NEGATIVE_INFINITY);
                bs = this.graph.GNodes.inArcs[dest];
                assert (!bs.isEmpty());
                int[] inlist = bs._getStructure();
                int insize = bs.size();
                for (x = 0; x < insize; ++x) {
                    e2 = inlist[x];
                    if (this.graph.isInStack(e2)) continue;
                    int orig = this.graph.GArcs.origs[e2];
                    cost = this.graph.GArcs.originalCost[e2];
                    for (d2 = 0; d2 < nbr; ++d2) {
                        if (this.spfs[dest][d2] > cost[d2] + this.spfs[orig][d2]) {
                            this.spfs[dest][d2] = cost[d2] + this.spfs[orig][d2];
                            this.prevSP[dest][d2] = e2;
                            update = true;
                        }
                        if (!(this.lpfs[dest][d2] < this.lpfs[orig][d2] + cost[d2])) continue;
                        this.lpfs[dest][d2] = this.lpfs[orig][d2] + cost[d2];
                        this.prevLP[dest][d2] = e2;
                        update = true;
                    }
                }
            }
            if (update) continue;
            propagator.fails();
        }
        for (i = this.nbLayer - 1; i >= 0; --i) {
            update = false;
            list = this.graph.layers[i]._getStructure();
            size = this.graph.layers[i].size();
            for (w = size - 1; w >= 0; --w) {
                int orig = list[w];
                Arrays.fill(this.spft[orig], Double.POSITIVE_INFINITY);
                Arrays.fill(this.lpft[orig], Double.NEGATIVE_INFINITY);
                bs = this.graph.GNodes.outArcs[orig];
                assert (!bs.isEmpty());
                int[] outlist = bs._getStructure();
                int outsize = bs.size();
                block7: for (x = 0; x < outsize; ++x) {
                    e2 = outlist[x];
                    if (this.graph.isInStack(e2)) continue;
                    int dest = this.graph.GArcs.dests[e2];
                    cost = this.graph.GArcs.originalCost[e2];
                    for (d2 = 0; d2 < nbr; ++d2) {
                        if (this.spft[dest][d2] + cost[d2] + this.spfs[orig][d2] - (double)z[d2].getUB() >= propagator._MCR_DECIMAL_PREC) {
                            this.graph.getInStack().set(e2);
                            removed.push(e2);
                            continue block7;
                        }
                        if (this.spft[orig][d2] > this.spft[dest][d2] + cost[d2]) {
                            this.spft[orig][d2] = this.spft[dest][d2] + cost[d2];
                            this.nextSP[orig][d2] = e2;
                            update = true;
                        }
                        if (this.lpft[dest][d2] + cost[d2] + this.lpfs[orig][d2] - (double)z[d2].getLB() <= -propagator._MCR_DECIMAL_PREC) {
                            this.graph.setInStack(e2);
                            removed.push(e2);
                            continue block7;
                        }
                        if (!(this.lpft[orig][d2] < this.lpft[dest][d2] + cost[d2])) continue;
                        this.lpft[orig][d2] = this.lpft[dest][d2] + cost[d2];
                        this.nextLP[orig][d2] = e2;
                        update = true;
                    }
                }
            }
            if (update) continue;
            propagator.fails();
        }
        this.modified[0] = z[0].updateLowerBound((int)Math.ceil(this.spft[this.graph.sourceIndex][0]), propagator);
        this.modified[1] = z[0].updateUpperBound((int)Math.floor(this.lpft[this.graph.sourceIndex][0]), propagator);
        for (i = 1; i < nbr; ++i) {
            z[i].updateLowerBound((int)Math.ceil(this.spft[this.graph.sourceIndex][i]), propagator);
            z[i].updateUpperBound((int)Math.floor(this.lpft[this.graph.sourceIndex][i]), propagator);
        }
        return this.modified;
    }
}

