/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PropSumOfElements
extends Propagator<Variable> {
    private final IntVar sum;
    private final SetVar set;
    private final int offSet;
    private final int[] weights;

    public PropSumOfElements(SetVar setVar, int[] weights, int offset, IntVar sum) {
        super(new Variable[]{setVar, sum}, (Priority)PropagatorPriority.BINARY, false);
        this.sum = (IntVar)this.vars[1];
        this.set = (SetVar)this.vars[0];
        this.weights = weights;
        this.offSet = offset;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx == 0) {
            return SetEventType.all();
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int lbSum = 0;
        int ubPosSum = 0;
        int ubNegSum = 0;
        ISetIterator iter = this.set.getUB().iterator();
        while (iter.hasNext()) {
            int j = iter.nextInt();
            if (this.outOfScope(j)) {
                this.set.remove(j, this);
                continue;
            }
            if (this.set.getLB().contains(j)) {
                lbSum += this.get(j);
                continue;
            }
            if (this.get(j) >= 0) {
                ubPosSum += this.get(j);
                continue;
            }
            ubNegSum += this.get(j);
        }
        int min2 = lbSum + ubNegSum;
        int max = lbSum + ubPosSum;
        this.sum.updateBounds(min2, max, this);
        int lb = this.sum.getLB();
        int ub = this.sum.getUB();
        if (lb == min2 && ub == max) {
            return;
        }
        iter = this.set.getUB().iterator();
        while (iter.hasNext()) {
            int j = iter.nextInt();
            if (this.set.getLB().contains(j)) continue;
            if (min2 + this.get(j) > ub) {
                if (!this.set.remove(j, this)) continue;
                ubPosSum -= this.get(j);
                continue;
            }
            if (max + this.get(j) < lb) {
                if (!this.set.remove(j, this)) continue;
                ubNegSum -= this.get(j);
                continue;
            }
            if (max - this.get(j) >= lb && min2 - this.get(j) <= ub || !this.set.force(j, this)) continue;
            lbSum += this.get(j);
        }
        min2 = lbSum + ubNegSum;
        max = lbSum + ubPosSum;
        this.sum.updateBounds(min2, max, this);
    }

    private boolean outOfScope(int j) {
        return this.weights != null && (j < this.offSet || j >= this.offSet + this.weights.length);
    }

    private int get(int j) {
        return this.weights == null ? j : this.weights[j - this.offSet];
    }

    @Override
    public ESat isEntailed() {
        int lbSum = 0;
        int ubPosSum = 0;
        int ubNegSum = 0;
        ISetIterator iter = this.set.getUB().iterator();
        while (iter.hasNext()) {
            int j = iter.nextInt();
            if (this.set.getLB().contains(j)) {
                if (this.outOfScope(j)) {
                    return ESat.FALSE;
                }
                lbSum += this.get(j);
                continue;
            }
            if (this.outOfScope(j)) continue;
            if (this.get(j) >= 0) {
                ubPosSum += this.get(j);
                continue;
            }
            ubNegSum += this.get(j);
        }
        int min2 = lbSum + ubNegSum;
        int max = lbSum + ubPosSum;
        if (this.sum.getLB() > max || this.sum.getUB() < min2) {
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

