/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.expression.continuous.relational;

import java.util.ArrayList;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.expression.continuous.arithmetic.CArExpression;
import org.chocosolver.solver.expression.continuous.arithmetic.RealIntervalConstant;
import org.chocosolver.solver.expression.continuous.relational.CReExpression;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.RealInterval;
import org.chocosolver.util.tools.RealUtils;

public class PropEquation
extends Propagator<RealVar> {
    protected RealIntervalConstant cste;
    protected CArExpression exp;
    protected CArExpression[] subExps;
    protected int nbBoxedVars = 0;
    protected RealVar[] boxedVars;
    protected CArExpression[][] subExpsWX;
    protected CArExpression[][] subExpsWOX;
    protected int boxConsistencyDepth = 6;
    RealInterval[] unexplored = new RealInterval[this.boxConsistencyDepth * 2];

    public PropEquation(RealVar[] vars, CArExpression e1, CReExpression.Operator op) {
        super((Variable[])vars, (Priority)PropagatorPriority.LINEAR, false);
        this.exp = e1;
        switch (op) {
            case LT: {
                this.cste = new RealIntervalConstant(Double.NEGATIVE_INFINITY, -RealUtils.nextFloat(0.0));
                break;
            }
            case LE: {
                this.cste = new RealIntervalConstant(Double.NEGATIVE_INFINITY, 0.0);
                break;
            }
            case GE: {
                this.cste = new RealIntervalConstant(0.0, Double.POSITIVE_INFINITY);
                break;
            }
            case GT: {
                this.cste = new RealIntervalConstant(RealUtils.nextFloat(0.0), Double.POSITIVE_INFINITY);
                break;
            }
            case EQ: {
                this.cste = new RealIntervalConstant(0.0, 0.0);
            }
        }
        this.boxedVars = new RealVar[vars.length];
        this.subExpsWX = new CArExpression[vars.length][];
        this.subExpsWOX = new CArExpression[vars.length][];
        for (int i = 0; i < vars.length; ++i) {
            RealVar var = vars[i];
            this.addBoxedVar(var);
        }
        this.exp.init();
        ArrayList<CArExpression> collectedSubExp = new ArrayList<CArExpression>();
        this.exp.subExps(collectedSubExp);
        this.subExps = collectedSubExp.toArray(new CArExpression[0]);
    }

    public void addBoxedVar(RealVar var) {
        ArrayList<CArExpression> wx = new ArrayList<CArExpression>();
        ArrayList<CArExpression> wox = new ArrayList<CArExpression>();
        this.exp.isolate(var, wx, wox);
        this.boxedVars[this.nbBoxedVars] = var;
        this.subExpsWX[this.nbBoxedVars] = wx.toArray(new CArExpression[0]);
        this.subExpsWOX[this.nbBoxedVars] = wox.toArray(new CArExpression[0]);
        ++this.nbBoxedVars;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.tighten(this.subExps);
        this.proj();
        for (int i = 0; i < this.nbBoxedVars; ++i) {
            this.bc(this.boxedVars[i], this.subExpsWX[i], this.subExpsWOX[i]);
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            return ESat.eval(this.not_inconsistent(this.subExps));
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return this.exp.toString() + " = " + this.cste.toString();
    }

    public void tighten(CArExpression[] exps) throws ContradictionException {
        for (CArExpression exp : exps) {
            exp.tighten();
            if (!(exp.getLB() > exp.getUB())) continue;
            this.fails();
        }
    }

    private boolean not_inconsistent(CArExpression[] wx) {
        boolean contradiction = false;
        try {
            this.tighten(wx);
        }
        catch (ContradictionException e2) {
            contradiction = true;
        }
        if (contradiction) {
            return false;
        }
        return this.exp.getLB() <= this.cste.getUB() && this.exp.getUB() >= this.cste.getLB();
    }

    protected void bc(RealVar var, CArExpression[] wx, CArExpression[] wox) throws ContradictionException {
        int[] depths = new int[this.boxConsistencyDepth * 2];
        int depth = 0;
        int idx = 0;
        boolean fin = false;
        double leftB = 0.0;
        double rightB = 0.0;
        double[] oldValue = new double[]{var.getLB(), var.getUB()};
        this.tighten(wox);
        while (!fin) {
            if (this.not_inconsistent(wx)) {
                if (this.boxConsistencyDepth <= depth) {
                    leftB = var.getLB();
                    rightB = var.getUB();
                    fin = true;
                    continue;
                }
                RealInterval left = RealUtils.firstHalf(var);
                RealInterval right = RealUtils.secondHalf(var);
                var.silentlyAssign(left);
                this.unexplored[idx] = right;
                depths[idx] = ++depth;
                ++idx;
                continue;
            }
            if (idx != 0) {
                var.silentlyAssign(this.unexplored[--idx]);
                depth = depths[idx];
                continue;
            }
            this.fails();
        }
        RealInterval[] tmp1 = new RealInterval[this.boxConsistencyDepth * 2];
        int[] tmp2 = new int[this.boxConsistencyDepth * 2];
        for (int i = 0; i < idx; ++i) {
            int j = idx - i - 1;
            tmp1[i] = this.unexplored[j];
            tmp2[i] = depths[j];
        }
        this.unexplored = tmp1;
        depths = tmp2;
        if (idx != 0) {
            var.silentlyAssign(this.unexplored[--idx]);
            depth = depths[idx];
            fin = false;
            while (!fin) {
                if (this.not_inconsistent(wx)) {
                    if (this.boxConsistencyDepth <= depth) {
                        rightB = var.getUB();
                        fin = true;
                        continue;
                    }
                    RealInterval left = RealUtils.firstHalf(var);
                    RealInterval right = RealUtils.secondHalf(var);
                    var.silentlyAssign(right);
                    this.unexplored[idx] = left;
                    depths[idx] = ++depth;
                    ++idx;
                    continue;
                }
                if (idx != 0) {
                    var.silentlyAssign(this.unexplored[--idx]);
                    depth = depths[idx];
                    continue;
                }
                fin = true;
            }
        }
        var.silentlyAssign(oldValue[0], oldValue[1]);
        var.intersect(leftB, rightB, this);
    }

    public void proj() throws ContradictionException {
        this.subExps[this.subExps.length - 1].intersect(this.cste, this);
        for (int i = this.subExps.length - 1; i > 0; --i) {
            this.subExps[i].project(this);
        }
    }
}

