/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.selectors.values.graph.edge;

import gnu.trove.list.array.TIntArrayList;
import java.util.Random;
import org.chocosolver.solver.search.strategy.selectors.values.graph.edge.GraphEdgeSelector;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class GraphRandomEdge
implements GraphEdgeSelector {
    private final Random rd;
    private final TIntArrayList pFrom;
    private final TIntArrayList pTo;

    public GraphRandomEdge(long seed) {
        this.rd = new Random(seed);
        this.pFrom = new TIntArrayList();
        this.pTo = new TIntArrayList();
    }

    public int[] selectEdge(GraphVar g2) {
        this.pFrom.clear();
        this.pTo.clear();
        ISetIterator iSetIterator = g2.getPotentialNodes().iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            ISet envSuc = g2.getPotentialSuccessorsOf(i);
            ISet kerSuc = g2.getMandatorySuccessorsOf(i);
            if (envSuc.size() == kerSuc.size()) continue;
            ISetIterator iSetIterator2 = envSuc.iterator();
            while (iSetIterator2.hasNext()) {
                int j = (Integer)iSetIterator2.next();
                if (kerSuc.contains(j)) continue;
                this.pFrom.add(i);
                this.pTo.add(j);
            }
        }
        if (this.pFrom.isEmpty()) {
            return new int[]{-1, -1};
        }
        int idx = this.rd.nextInt(this.pFrom.size());
        return new int[]{this.pFrom.get(idx), this.pTo.get(idx)};
    }
}

