/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.selectors.values.graph.priority;

import org.chocosolver.solver.search.strategy.selectors.values.graph.edge.GraphEdgeSelector;
import org.chocosolver.solver.search.strategy.selectors.values.graph.node.GraphNodeSelector;
import org.chocosolver.solver.search.strategy.selectors.values.graph.priority.GraphNodeOrEdgeSelector;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class GraphNodeThenNeighbors
implements GraphNodeOrEdgeSelector,
GraphNodeSelector,
GraphEdgeSelector {
    private int currentNode = -1;
    private int nextTo = -1;
    private GraphVar g = null;

    public boolean nextIsNode(GraphVar graphVar) {
        if (this.g != graphVar && this.init(graphVar)) {
            return true;
        }
        this.nextTo = this.findNextEdge();
        while (this.nextTo == -1) {
            if (this.findNextNode()) {
                return true;
            }
            this.nextTo = this.findNextEdge();
        }
        return false;
    }

    public int[] selectEdge(GraphVar graphVar) {
        assert (graphVar == this.g);
        return new int[]{this.currentNode, this.nextTo};
    }

    public int selectNode(GraphVar graphVar) {
        assert (graphVar == this.g);
        return this.currentNode;
    }

    private int findNextEdge() {
        ISetIterator iSetIterator = this.g.getPotentialSuccessorsOf(this.currentNode).iterator();
        while (iSetIterator.hasNext()) {
            int j = (Integer)iSetIterator.next();
            if (!this.g.getMandatoryNodes().contains(j) || this.g.getMandatorySuccessorsOf(this.currentNode).contains(j)) continue;
            return j;
        }
        return -1;
    }

    private boolean findNextNode() {
        int i;
        ISetIterator iSetIterator = this.g.getPotentialNodes().iterator();
        while (iSetIterator.hasNext()) {
            i = (Integer)iSetIterator.next();
            if (this.g.getMandatoryNodes().contains(i)) continue;
            this.currentNode = i;
            return true;
        }
        iSetIterator = this.g.getMandatoryNodes().iterator();
        while (iSetIterator.hasNext()) {
            i = (Integer)iSetIterator.next();
            if (this.g.getMandatorySuccessorsOf(i).size() == this.g.getPotentialSuccessorsOf(i).size()) continue;
            this.currentNode = i;
            return false;
        }
        this.currentNode = -1;
        return false;
    }

    private boolean init(GraphVar graphVar) {
        this.g = graphVar;
        return this.findNextNode();
    }
}

