/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.selectors.variables;

import gnu.trove.map.hash.TObjectDoubleHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.search.loop.monitors.IMonitorInitialize;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperatorFactory;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;

public class ClausesBased
extends AbstractStrategy<IntVar>
implements IMonitorInitialize {
    protected TObjectDoubleHashMap<IntVar> activity;
    Solver solver;
    double var_inc = 1.0;
    private final List<IntVar> bests;
    private final ToDoubleFunction<IntVar> tiebreaker;
    private final ToIntFunction<IntVar> valueSelector;

    public ClausesBased(Model model, IntVar[] decisions, ToDoubleFunction<IntVar> tiebreaker, ToIntFunction<IntVar> valueSelector) {
        super((Variable[])decisions);
        this.solver = model.getSolver();
        this.valueSelector = valueSelector;
        this.activity = new TObjectDoubleHashMap(16, 1.5f, 0.0);
        for (IntVar v : decisions) {
            this.activity.put(v, 1.0);
        }
        this.tiebreaker = tiebreaker;
        this.bests = new ArrayList<IntVar>();
        model.getSolver().plugMonitor(this);
    }

    @Override
    public boolean init() {
        this.solver.getModel().getClauseConstraint().getClauseStore().declareClausesBasedStrategy(this);
        return true;
    }

    public void bump(IntVar v) {
        this.activity.adjustOrPutValue(v, this.var_inc, 1.0);
    }

    public void decayActivity() {
        double d2;
        this.var_inc *= 1.05;
        if (d2 > 1.0E100) {
            for (Object v : this.activity.keys()) {
                double act = this.activity.get(v);
                this.activity.adjustValue((IntVar)v, act * 1.0E-100);
            }
            this.var_inc *= 1.0E-100;
        }
    }

    @Override
    public Decision<IntVar> getDecision() {
        IntVar best = null;
        this.bests.clear();
        double[] bst = new double[]{-2.147483648E9};
        this.activity.forEachEntry((var, act) -> {
            if (!var.isInstantiated() && act >= bst[0]) {
                if (act > bst[0]) {
                    this.bests.clear();
                    bst[0] = act;
                }
                this.bests.add((IntVar)var);
            }
            return true;
        });
        if (this.bests.size() > 0) {
            best = this.bests.get(0);
            bst[0] = this.tiebreaker.applyAsDouble(best);
            for (int i = 1; i < this.bests.size(); ++i) {
                double d2;
                double tmp = this.tiebreaker.applyAsDouble(this.bests.get(i));
                if (!(d2 < bst[0])) continue;
                bst[0] = tmp;
                best = this.bests.get(i);
            }
        }
        return this.computeDecision(best);
    }

    @Override
    public Decision<IntVar> computeDecision(IntVar variable) {
        if (variable == null || variable.isInstantiated()) {
            return null;
        }
        int currentVal = this.valueSelector.applyAsInt(variable);
        return variable.getModel().getSolver().getDecisionPath().makeIntDecision(variable, DecisionOperatorFactory.makeIntEq(), currentVal);
    }
}

