/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.strategy;

import org.chocosolver.solver.search.strategy.assignments.DecisionOperator;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperatorFactory;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainRandom;
import org.chocosolver.solver.search.strategy.selectors.variables.Random;
import org.chocosolver.solver.search.strategy.selectors.variables.VariableSelector;
import org.chocosolver.solver.search.strategy.strategy.IntStrategy;
import org.chocosolver.solver.variables.IntVar;

public class FullyRandom
extends IntStrategy {
    private final DecisionOperator<IntVar>[] dops = new DecisionOperator[]{DecisionOperatorFactory.makeIntEq(), DecisionOperatorFactory.makeIntNeq(), DecisionOperatorFactory.makeIntSplit(), DecisionOperatorFactory.makeIntReverseSplit()};
    private final java.util.Random rnd;

    public FullyRandom(IntVar[] scope, long seed) {
        super(scope, (VariableSelector<IntVar>)new Random<IntVar>(seed), new IntDomainRandom(seed));
        this.rnd = new java.util.Random(seed);
    }

    @Override
    public Decision<IntVar> computeDecision(IntVar variable) {
        if (variable == null || variable.isInstantiated()) {
            return null;
        }
        int value = this.valueSelector.selectValue(variable);
        DecisionOperator<IntVar> dop = this.dops[this.rnd.nextInt(4)];
        if (dop == this.dops[2] && value == variable.getUB()) {
            dop = this.dops[3];
        } else if (dop == this.dops[3] && value == variable.getLB()) {
            dop = this.dops[2];
        }
        if (!variable.hasEnumeratedDomain() && value != variable.getLB() && value != variable.getUB()) {
            dop = this.dops[2 + this.rnd.nextInt(2)];
        }
        return variable.getModel().getSolver().getDecisionPath().makeIntDecision(variable, dop, value);
    }
}

