/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.decomposition;

public class TriangularSolver_DDRM {
    public static void invertLower(double[] L, int m3) {
        for (int i = 0; i < m3; ++i) {
            double L_ii = L[i * m3 + i];
            for (int j = 0; j < i; ++j) {
                double val = 0.0;
                for (int k = j; k < i; ++k) {
                    val += L[i * m3 + k] * L[k * m3 + j];
                }
                L[i * m3 + j] = -val / L_ii;
            }
            L[i * m3 + i] = 1.0 / L_ii;
        }
    }

    public static void invertLower(double[] L, double[] L_inv, int m3) {
        for (int i = 0; i < m3; ++i) {
            double L_ii = L[i * m3 + i];
            for (int j = 0; j < i; ++j) {
                double val = 0.0;
                for (int k = j; k < i; ++k) {
                    val -= L[i * m3 + k] * L_inv[k * m3 + j];
                }
                L_inv[i * m3 + j] = val / L_ii;
            }
            L_inv[i * m3 + i] = 1.0 / L_ii;
        }
    }

    public static void solveL(double[] L, double[] b2, int n) {
        for (int i = 0; i < n; ++i) {
            double sum = b2[i];
            int indexL = i * n;
            for (int k = 0; k < i; ++k) {
                sum -= L[indexL++] * b2[k];
            }
            b2[i] = sum / L[indexL];
        }
    }

    public static void solveL(double[] L, double[] b2, int m3, int n) {
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m3; ++i) {
                double sum = b2[i * n + j];
                for (int k = 0; k < i; ++k) {
                    sum -= L[i * m3 + k] * b2[k * n + j];
                }
                b2[i * n + j] = sum / L[i * m3 + i];
            }
        }
    }

    public static void solveTranL(double[] L, double[] b2, int n) {
        for (int i = n - 1; i >= 0; --i) {
            double sum = b2[i];
            for (int k = i + 1; k < n; ++k) {
                sum -= L[k * n + i] * b2[k];
            }
            b2[i] = sum / L[i * n + i];
        }
    }

    public static void solveU(double[] U, double[] b2, int n) {
        for (int i = n - 1; i >= 0; --i) {
            double sum = b2[i];
            int indexU = i * n + i + 1;
            for (int j = i + 1; j < n; ++j) {
                sum -= U[indexU++] * b2[j];
            }
            b2[i] = sum / U[i * n + i];
        }
    }

    public static void solveU(double[] U, double[] b2, int sideLength, int minRow, int maxRow) {
        for (int i = maxRow - 1; i >= minRow; --i) {
            double sum = b2[i];
            int indexU = i * sideLength + i + 1;
            for (int j = i + 1; j < maxRow; ++j) {
                sum -= U[indexU++] * b2[j];
            }
            b2[i] = sum / U[i * sideLength + i];
        }
    }

    public static void solveU(double[] U, int startU, int strideU, int widthU, double[] b2, int startB, int strideB, int widthB) {
        for (int colB = 0; colB < widthB; ++colB) {
            for (int i = widthU - 1; i >= 0; --i) {
                double sum = b2[startB + i * strideB + colB];
                for (int j = i + 1; j < widthU; ++j) {
                    sum -= U[startU + i * strideU + j] * b2[startB + j * strideB + colB];
                }
                b2[startB + i * strideB + colB] = sum / U[startU + i * strideU + i];
            }
        }
    }
}

