/*
 * Decompiled with CFR 0.152.
 */
package org.flsgen.cli;

import java.io.File;
import java.io.IOException;
import org.flsgen.grid.regular.square.RegularSquareGrid;
import org.flsgen.solver.Terrain;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.geotiff.GeoTiffReader;
import picocli.CommandLine;

@CommandLine.Command(name="terrain", mixinStandardHelpOptions=true, description={"Generate a fractal terrain using the Diamond-Square algorithm."})
public class CLI_FractalTerrain
implements Runnable {
    @CommandLine.Option(names={"-H", "--height"}, description={"Height (in pixels) of the terrain to generate"}, required=true)
    int nbRows;
    @CommandLine.Option(names={"-W", "--width"}, description={"Width (in pixels) of the terrain to generate"}, required=true)
    int nbCols;
    @CommandLine.Option(names={"-R", "--roughness"}, description={"Roughness parameter (also called H), between 0 and 1. Lower values produce rougher terrain (0.5 by default)"}, defaultValue="0.5")
    double roughnessFactor;
    @CommandLine.Option(names={"-x"}, description={"Top left x coordinate of the output raster (default 0)"}, defaultValue="0")
    double x;
    @CommandLine.Option(names={"-y"}, description={"Top left y coordinate of the output raster (default 0)"}, defaultValue="0")
    double y;
    @CommandLine.Option(names={"-r", "--resolution"}, description={"Spatial resolution of the output raster (in CRS unit, default 0.0001)"}, defaultValue="0.0001")
    double resolution;
    @CommandLine.Option(names={"-s", "-srs", "--spatial-reference-system"}, description={"Spatial reference system of the output raster (default: EPSG:4326)"}, defaultValue="EPSG:4326")
    String srs;
    @CommandLine.Option(names={"-t", "-ot", "--output-template"}, description={"Raster template to use for output raster metadata"}, defaultValue="")
    String template;
    @CommandLine.Parameters(description={"Path to the raster to generate as output"})
    String output;

    @Override
    public void run() {
        try {
            if (this.roughnessFactor < 0.0 || this.roughnessFactor > 1.0) {
                System.err.println("\u001b[31mRoughness factor must be in [0, 1]\u001b[0m");
                return;
            }
            if (!this.template.equals("")) {
                this.initRasterMetadataFromTemplate(this.template);
            }
            RegularSquareGrid grid = new RegularSquareGrid(this.nbRows, this.nbCols);
            Terrain terrain = new Terrain(grid);
            terrain.generateDiamondSquare(this.roughnessFactor);
            terrain.exportRaster(this.x, this.y, this.resolution, this.srs, this.output);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void initRasterMetadataFromTemplate(String input) throws IOException {
        File file = new File(input);
        GeoTiffReader reader = new GeoTiffReader(file);
        GridCoverage2D gridCov = reader.read(null);
        this.resolution = gridCov.getEnvelope2D().getHeight() / (double)gridCov.getRenderedImage().getHeight();
        this.srs = gridCov.getEnvelope2D().getCoordinateReferenceSystem().getIdentifiers().iterator().next().toString();
        this.x = gridCov.getEnvelope2D().getMinX();
        this.y = gridCov.getEnvelope2D().getMinY();
        gridCov.dispose(true);
        reader.dispose();
    }
}

