/*
 * Decompiled with CFR 0.152.
 */
package org.flsgen.solver;

import java.awt.image.DataBuffer;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.stream.IntStream;
import javax.media.jai.RasterFactory;
import org.flsgen.exception.FlsgenException;
import org.flsgen.grid.regular.square.RegularSquareGrid;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class Terrain {
    protected RegularSquareGrid grid;
    protected double[] dem;

    public Terrain(RegularSquareGrid grid) {
        this.grid = grid;
    }

    public void loadFromRaster(String rasterPath) throws IOException, FlsgenException {
        File file = new File(rasterPath);
        GeoTiffReader reader = new GeoTiffReader(file);
        GridCoverage2D gridCov = reader.read(null);
        int nRow = gridCov.getRenderedImage().getHeight();
        int nCol = gridCov.getRenderedImage().getWidth();
        if (nRow != this.grid.getNbRows() || nCol != this.grid.getNbCols()) {
            throw new FlsgenException("Input terrain raster must have the same dimensions as the landscape to generate");
        }
        DataBuffer buff = gridCov.getRenderedImage().getData().getDataBuffer();
        this.dem = IntStream.range(0, this.grid.getNbCells()).mapToDouble(i -> buff.getElemDouble(i)).toArray();
        gridCov.dispose(true);
        reader.dispose();
    }

    public void generateDiamondSquare(double roughnessFactor) {
        int h2 = Math.max(this.grid.getNbRows(), this.grid.getNbCols());
        double pos = Math.ceil(Math.log(h2) / Math.log(2.0));
        h2 = (int)(Math.pow(2.0, pos) + 1.0);
        double[][] terrain = new double[h2][h2];
        terrain[0][0] = Terrain.randomDouble(-h2, h2);
        terrain[0][h2 - 1] = Terrain.randomDouble(-h2, h2);
        terrain[h2 - 1][0] = Terrain.randomDouble(-h2, h2);
        terrain[h2 - 1][h2 - 1] = Terrain.randomDouble(-h2, h2);
        double r = (double)h2 * Math.pow(2.0, -2.0 * roughnessFactor);
        int i = h2 - 1;
        while (i > 1) {
            int id;
            for (int x = id = i / 2; x < h2; x += i) {
                for (int y = id; y < h2; y += i) {
                    double mean = (terrain[x - id][y - id] + terrain[x - id][y + id] + terrain[x + id][y + id] + terrain[x + id][y - id]) / 4.0;
                    terrain[x][y] = mean + Terrain.randomDouble(-r, r);
                }
            }
            int offset = 0;
            for (int x = 0; x < h2; x += id) {
                offset = offset == 0 ? id : 0;
                for (int y = offset; y < h2; y += i) {
                    double sum = 0.0;
                    int n = 0;
                    if (x >= id) {
                        sum += terrain[x - id][y];
                        ++n;
                    }
                    if (x + id < h2) {
                        sum += terrain[x + id][y];
                        ++n;
                    }
                    if (y >= id) {
                        sum += terrain[x][y - id];
                        ++n;
                    }
                    if (y + id < h2) {
                        sum += terrain[x][y + id];
                        ++n;
                    }
                    terrain[x][y] = sum / (double)n + Terrain.randomDouble(-r, r);
                }
            }
            i = id;
            r *= Math.pow(2.0, -2.0 * roughnessFactor);
        }
        this.dem = IntStream.range(0, this.grid.getNbCells()).mapToDouble(v -> {
            int[] c2 = this.grid.getCoordinatesFromIndex(v);
            return terrain[c2[0]][c2[1]];
        }).toArray();
    }

    public static double randomDouble(double min2, double max) {
        return new Random().nextDouble() * (max - min2) + min2;
    }

    public void exportRaster(double x, double y, double resolution_x, double resolution_y, String epsg, String dest) throws IOException, FactoryException {
        GridCoverageFactory gcf = new GridCoverageFactory();
        CoordinateReferenceSystem crs = CRS.decode(epsg);
        ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope(x, x + (double)this.grid.getNbCols() * resolution_x, y - (double)this.grid.getNbRows() * resolution_y, y, crs);
        WritableRaster rast = RasterFactory.createBandedRaster(5, this.grid.getNbCols(), this.grid.getNbRows(), 1, null);
        rast.setPixels(0, 0, this.grid.getNbCols(), this.grid.getNbRows(), this.dem);
        GridCoverage2D gc = gcf.create((CharSequence)"generated_landscape", rast, (Envelope)referencedEnvelope);
        GeoTiffWriter writer = new GeoTiffWriter(new File(dest));
        writer.write(gc, null);
        System.out.println("Fractal terrain raster exported at " + dest);
        gc.dispose(true);
        writer.dispose();
    }

    public void exportRaster(double x, double y, double resolution, String epsg, String dest) throws IOException, FactoryException {
        this.exportRaster(x, y, resolution, resolution, epsg, dest);
    }
}

