/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.geotools.data.DataAccess;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.LockingManager;
import org.geotools.data.Repository;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.NameImpl;
import org.opengis.feature.type.Name;

public class DefaultRepository
implements Repository {
    protected Map<Name, DataAccess<?, ?>> repository = new ConcurrentHashMap();

    public DataAccess<?, ?> access(String name) {
        return this.access((Name)new NameImpl(name));
    }

    @Override
    public DataAccess<?, ?> access(Name name) {
        return this.repository.get(name);
    }

    public DataStore dataStore(String name) {
        return (DataStore)this.access(name);
    }

    @Override
    public DataStore dataStore(Name name) {
        return (DataStore)this.access(name);
    }

    public void load(File propertiesFile) throws Exception {
        Properties properties = new Properties();
        properties.load(new FileInputStream(propertiesFile));
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String name = (String)entry.getKey();
            String definition = (String)entry.getValue();
            Map<String, Serializable> params = DefaultRepository.definition(definition);
            DataStore dataStore = DataStoreFinder.getDataStore(params);
            this.register(name, dataStore);
        }
    }

    public boolean lockExists(String lockID) {
        if (lockID == null) {
            return false;
        }
        for (DataAccess<?, ?> access : this.repository.values()) {
            DataStore store = (DataStore)access;
            LockingManager lockManager = store.getLockingManager();
            if (lockManager == null || !lockManager.exists(lockID)) continue;
            return true;
        }
        return false;
    }

    public boolean lockRefresh(String lockID, Transaction transaction) throws IOException {
        if (lockID == null) {
            throw new IllegalArgumentException("lockID required");
        }
        if (transaction == null || transaction == Transaction.AUTO_COMMIT) {
            throw new IllegalArgumentException("Tansaction required (with authorization for " + lockID + ")");
        }
        boolean refresh = false;
        for (DataAccess<?, ?> access : this.repository.values()) {
            DataStore store = (DataStore)access;
            LockingManager lockManager = store.getLockingManager();
            if (lockManager == null || !lockManager.release(lockID, transaction)) continue;
            refresh = true;
        }
        return refresh;
    }

    public boolean lockRelease(String lockID, Transaction transaction) throws IOException {
        if (lockID == null) {
            throw new IllegalArgumentException("lockID required");
        }
        if (transaction == null || transaction == Transaction.AUTO_COMMIT) {
            throw new IllegalArgumentException("Tansaction required (with authorization for " + lockID + ")");
        }
        boolean release = false;
        for (DataAccess<?, ?> access : this.repository.values()) {
            DataStore store = (DataStore)access;
            LockingManager lockManager = store.getLockingManager();
            if (lockManager == null || !lockManager.release(lockID, transaction)) continue;
            release = true;
        }
        return release;
    }

    public void register(String name, DataAccess<?, ?> dataStore) throws IOException {
        this.register((Name)new NameImpl(name), dataStore);
    }

    public void register(Name name, DataAccess<?, ?> dataStore) throws IOException {
        if (this.repository.containsKey(name)) {
            throw new IOException("Name " + name + " already registered");
        }
        if (this.repository.containsValue(dataStore)) {
            throw new IOException("The dataStore already registered");
        }
        this.repository.put(name, dataStore);
    }

    public DataStore datastore(String id) {
        return this.dataStore((Name)new NameImpl(id));
    }

    public SimpleFeatureSource source(String dataStoreId, String typeName) throws IOException {
        DataStore ds = this.datastore(dataStoreId);
        return ds.getFeatureSource(typeName);
    }

    private static final Map<String, Serializable> definition(String definition) throws ParseException {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        String[] params = definition.split(",");
        int offset = 0;
        for (int i = 0; i < params.length; ++i) {
            String[] vals = params[i].split("=");
            if (vals.length != 2) {
                throw new ParseException("Could not interpret " + params[i], offset);
            }
            map.put(vals[0].trim(), (Serializable)((Object)vals[1].trim()));
            offset += params[i].length();
        }
        return map;
    }

    public Set<Name> getNames() {
        HashSet<Name> names = new HashSet<Name>(this.repository.keySet());
        return names;
    }

    @Override
    public List<DataStore> getDataStores() {
        ArrayList list = new ArrayList(this.repository.values());
        return list;
    }
}

